/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.es.api.client;

import com.valor.vod.es.api.client.ESApi;
import com.valor.vod.es.api.client.ESBulkProcessorListener;
import com.valor.vod.es.api.model.client.ESProperties;
import com.valor.vod.es.api.model.service.base.IDocument;
import com.valor.vod.es.api.tools.JacksonUtils;
import common.config.tools.config.ConfigTools3;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkProcessor;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.GetAliasesResponse;
import org.elasticsearch.client.IndicesClient;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESIndexApi
extends ESApi {
    private static final Logger logger = LoggerFactory.getLogger(ESIndexApi.class);
    protected BulkProcessor bulkProcessor = null;

    public ESIndexApi(ESProperties esProperties) {
        super(esProperties);
        this.initBulkProcessor();
    }

    public IndexResponse updateIndex(String index, String type, IDocument doc) {
        if (!this.hasInit()) {
            return null;
        }
        String json = this.toJson(doc);
        if (!Strings.isNullOrEmpty((String)json)) {
            IndexRequest indexRequest = new IndexRequest(index, type, doc.getDocumentId());
            indexRequest.source(json, XContentType.JSON);
            try {
                return this.client.index(indexRequest, new Header[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public BulkResponse bulkUpdateIndex(String index, String type, List<IDocument> docList, WriteRequest.RefreshPolicy policy) {
        BulkRequest bulkRequest = new BulkRequest();
        bulkRequest.setRefreshPolicy(policy);
        for (IDocument doc : docList) {
            String json = this.toJson(doc);
            if (Strings.isNullOrEmpty((String)json)) continue;
            try {
                bulkRequest.add(new IndexRequest(index, type, doc.getDocumentId()).source(json, XContentType.JSON));
            }
            catch (Exception e) {
                logger.error("bulkUpdateIndex bulkRequest error");
                return null;
            }
        }
        if (bulkRequest.numberOfActions() > 0) {
            try {
                return this.client.bulk(bulkRequest, new Header[0]);
            }
            catch (IOException e) {
                logger.error("[bulkUpdateIndex][ERROR],ex:", (Throwable)e);
                return null;
            }
        }
        logger.error("[bulkUpdateIndex] numberOfActions<=0");
        return null;
    }

    public BulkResponse bulkUpdateIndex(String index, String type, List<IDocument> docList) {
        return this.bulkUpdateIndex(index, type, docList, WriteRequest.RefreshPolicy.IMMEDIATE);
    }

    public void initBulkProcessor() {
        this.bulkProcessor = BulkProcessor.builder((x$0, x$1) -> this.client.bulkAsync(x$0, x$1, new Header[0]), (BulkProcessor.Listener)new ESBulkProcessorListener()).setBulkActions(this.properties.bulkSize()).setBulkSize(new ByteSizeValue((long)this.properties.bulkByteSize(), ByteSizeUnit.MB)).setFlushInterval(TimeValue.timeValueSeconds((long)this.properties.bulkFlushInterval())).setConcurrentRequests(this.properties.bulkConcurrent()).setBackoffPolicy(BackoffPolicy.exponentialBackoff((TimeValue)TimeValue.timeValueMillis((long)this.properties.bulkBackoffInitialdelay()), (int)this.properties.bulkBackoffRetry())).build();
    }

    public void closeBulkProcessor() {
        this.bulkProcessor.close();
    }

    public void bulkProcessorUpsert(String index, String type, IDocument document) {
        if (document == null) {
            return;
        }
        String json = this.toJson(document);
        if (!Strings.isNullOrEmpty((String)json)) {
            this.bulkProcessor.add(new IndexRequest(index, type, document.getDocumentId()).source(json, XContentType.JSON));
        }
    }

    public void bulkProcessorRemove(String index, String type, String id) {
        this.bulkProcessor.add(new DeleteRequest(index, type, id));
    }

    public BulkResponse bulkRemoveIndex(String index, String type, Set<String> docIdSet, WriteRequest.RefreshPolicy policy) {
        BulkRequest bulkRequest = new BulkRequest();
        bulkRequest.setRefreshPolicy(policy);
        for (String id : docIdSet) {
            bulkRequest.add(new DeleteRequest(index, type, id));
        }
        if (bulkRequest.numberOfActions() > 0) {
            try {
                return this.client.bulk(bulkRequest, new Header[0]);
            }
            catch (IOException e) {
                logger.error("[bulkRemoveIndex][ERROR],ex:", (Throwable)e);
                return null;
            }
        }
        logger.error("[bulkRemoveIndex] numberOfActions<=0");
        return null;
    }

    public Map<String, Object> bulkRemoveIndexByQueryById(String index, String type, List<Long> ids) {
        BoolQueryBuilder bqb = new BoolQueryBuilder();
        bqb.must((QueryBuilder)QueryBuilders.termsQuery((String)"id", ids));
        SearchSourceBuilder ssb = new SearchSourceBuilder();
        ssb.query((QueryBuilder)bqb);
        return this.perfromDeleteByQuery(index, type, ssb.toString());
    }

    public Map<String, Object> perfromDeleteByQuery(String index, String type, String queryJson) {
        long beginTime = System.currentTimeMillis();
        boolean printJson = ConfigTools3.getBoolean((String)"mfc.es.search.req.log.enabled", (boolean)false);
        if (printJson) {
            logger.info("[ESIndexApi][perfromRequest] queryJson[{}]", (Object)queryJson);
        }
        try {
            NStringEntity entity = new NStringEntity(queryJson, ContentType.APPLICATION_JSON);
            Request request = new Request("POST", "/" + index + "/" + type + "/_delete_by_query");
            request.setEntity((HttpEntity)entity);
            Response response = this.lowClient.performRequest(request);
            logger.debug("[ESIndexApi][perfromRequest] performRequest[{}]", (Object)(System.currentTimeMillis() - beginTime));
            beginTime = System.currentTimeMillis();
            Map<String, Object> result = JacksonUtils.parse2Map(response.getEntity().getContent());
            logger.debug("[ESSearchApi][perfromDeleteByQuery] parseContent[{}]", (Object)(System.currentTimeMillis() - beginTime));
            return result;
        }
        catch (ResponseException re) {
            if (re.getResponse().getStatusLine().getStatusCode() == 409) {
                logger.warn("[ESIndexApi][perfromRequest] return 409 code.");
            } else {
                logger.error("[ESIndexApi][perfromRequest] exception,", (Throwable)re);
            }
        }
        catch (IOException e) {
            logger.error("[ESIndexApi][perfromRequest] exception,", (Throwable)e);
        }
        return new HashMap<String, Object>();
    }

    public BulkResponse bulkRemoveIndex(String index, String type, List<String> ids) {
        BulkRequest bulkRequest = new BulkRequest();
        bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ids.forEach(id -> bulkRequest.add(new DeleteRequest(index, type, id)));
        if (bulkRequest.numberOfActions() > 0) {
            try {
                return this.client.bulk(bulkRequest, new Header[0]);
            }
            catch (IOException e) {
                logger.error("[bulkRemoveIndex][ERROR],ex:", (Throwable)e);
                return null;
            }
        }
        logger.error("[bulkRemoveIndex] numberOfActions<=0");
        return null;
    }

    public boolean createIndex(String index, String source) throws IOException {
        CreateIndexRequest request = new CreateIndexRequest(index);
        request.source(source, XContentType.JSON);
        IndicesClient indicesClient = this.client.indices();
        CreateIndexResponse response = indicesClient.create(request, RequestOptions.DEFAULT);
        return response.isAcknowledged();
    }

    public boolean indexExists(String index) throws IOException {
        GetIndexRequest request = new GetIndexRequest();
        request.indices(new String[]{index});
        request.includeDefaults(false);
        request.indicesOptions(IndicesOptions.lenientExpandOpen());
        return this.client.indices().exists(request, RequestOptions.DEFAULT);
    }

    public boolean deleteIndex(String index) throws IOException {
        DeleteIndexRequest request = new DeleteIndexRequest(index);
        DeleteIndexResponse resp = this.client.indices().delete(request, RequestOptions.DEFAULT);
        return resp.isAcknowledged();
    }

    public boolean addIndexAlias(String index, String alias) throws IOException {
        IndicesAliasesRequest request = new IndicesAliasesRequest();
        IndicesAliasesRequest.AliasActions aliasActions = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(index).alias(alias);
        request.addAliasAction(aliasActions);
        IndicesAliasesResponse response = this.client.indices().updateAliases(request, RequestOptions.DEFAULT);
        return response.isAcknowledged();
    }

    public boolean removeAlias(String index, String alias) throws IOException {
        IndicesAliasesRequest request = new IndicesAliasesRequest();
        IndicesAliasesRequest.AliasActions aliasActions = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE).index(index).alias(alias);
        request.addAliasAction(aliasActions);
        IndicesAliasesResponse response = this.client.indices().updateAliases(request, RequestOptions.DEFAULT);
        return response.isAcknowledged();
    }

    public boolean updateIndexAlias(String alias, List<String> delList, List<String> addList) throws IOException {
        IndicesAliasesRequest.AliasActions aliasActions;
        IndicesAliasesRequest request = new IndicesAliasesRequest();
        if (ObjectUtils.isNotEmpty(delList)) {
            for (String index : delList) {
                aliasActions = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.REMOVE_INDEX).index(index);
                request.addAliasAction(aliasActions);
            }
        }
        if (ObjectUtils.isNotEmpty(addList)) {
            for (String index : addList) {
                aliasActions = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).index(index).alias(alias);
                request.addAliasAction(aliasActions);
            }
        }
        IndicesAliasesResponse response = this.client.indices().updateAliases(request, RequestOptions.DEFAULT);
        return response.isAcknowledged();
    }

    public Set<String> getIndexesByAlias(String alias) throws IOException {
        GetAliasesRequest request = new GetAliasesRequest(new String[]{alias});
        request.indicesOptions(IndicesOptions.lenientExpandOpen());
        GetAliasesResponse response = this.client.indices().getAlias(request, RequestOptions.DEFAULT);
        Map map = response.getAliases();
        return map.keySet();
    }
}

