/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.es.api.client;

import com.google.common.collect.Lists;
import com.valor.vod.es.api.client.EESFilterType;
import com.valor.vod.es.api.client.ESApi;
import com.valor.vod.es.api.model.client.ESProperties;
import com.valor.vod.es.api.model.service.search.ESApiResponse;
import com.valor.vod.es.api.model.service.search.ESFunctionQueryParameter;
import com.valor.vod.es.api.model.service.search.ESIdResponse;
import com.valor.vod.es.api.model.service.search.ESNestedFilterBuilder;
import com.valor.vod.es.api.model.service.search.ESRangeFilterBuilder;
import com.valor.vod.es.api.model.service.search.ESSearchParameter;
import com.valor.vod.es.api.model.service.search.ESTermFilterBuilder;
import com.valor.vod.es.api.model.service.search.ESTextFilterBuilder;
import com.valor.vod.es.api.model.service.search.IESFilterBuilder;
import com.valor.vod.es.api.tools.JacksonUtils;
import common.base.tools.stat.TimeStatisticsTools;
import common.base.tools.type.CollectionUtils;
import common.config.tools.config.ConfigTools3;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Response;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.ScriptScoreFunctionBuilder;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightBuilder;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.ScoreSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESSearchApi
extends ESApi {
    private static final Logger logger = LoggerFactory.getLogger(ESSearchApi.class);

    public ESSearchApi(ESProperties esProperties) {
        super(esProperties);
    }

    public <T> ESApiResponse<T> search(ESSearchParameter parameter) {
        long beginTime = System.currentTimeMillis();
        String queryJson = this.parseParameter(parameter, false);
        boolean printJson = ConfigTools3.getBoolean((String)"mfc.es.search.req.log.enabled", (boolean)false);
        if (printJson) {
            logger.info("[ESSearchApi][search] queryJson[{}]", (Object)queryJson);
        }
        logger.debug("[ESSearchApi][search] queryJson[{}]", (Object)queryJson);
        logger.debug("[ESSearchApi][search] parseParameter[{}]", (Object)(System.currentTimeMillis() - beginTime));
        try {
            NStringEntity entity = new NStringEntity(queryJson, ContentType.APPLICATION_JSON);
            Request request = new Request("POST", "/" + parameter.getIndex() + "/" + parameter.getType() + "/_search");
            request.setEntity((HttpEntity)entity);
            Response response = this.lowClient.performRequest(request);
            logger.debug("[ESSearchApi][search] performRequest[{}]", (Object)(System.currentTimeMillis() - beginTime));
            beginTime = System.currentTimeMillis();
            NamedXContentRegistry registry = new NamedXContentRegistry(Stream.of(this.getDefaultNamedXContents().stream()).flatMap(Function.identity()).collect(Collectors.toList()));
            SearchResponse searchResponse = SearchResponse.fromXContent((XContentParser)JsonXContent.jsonXContent.createParser(registry, DEPRECATION_HANDLER, response.getEntity().getContent()));
            logger.debug("[ESSearchApi][search] parseContent[{}]", (Object)(System.currentTimeMillis() - beginTime));
            beginTime = System.currentTimeMillis();
            ESApiResponse esApiResponse = this.toResponse(searchResponse);
            TimeStatisticsTools.addTime((String)String.format("ES-respToObject", new Object[0]), (int)1, (long)(System.currentTimeMillis() - beginTime));
            logger.debug("[ESSearchApi][search] parseObject[{}]", (Object)(System.currentTimeMillis() - beginTime));
            return esApiResponse;
        }
        catch (IOException e) {
            logger.error("[ESSearchApi][search] exception,", (Throwable)e);
            return null;
        }
    }

    public <T> ESApiResponse<T> searchWithScroll(ESSearchParameter parameter, String timeLimit) {
        long beginTime = System.currentTimeMillis();
        String queryJson = this.parseParameter(parameter, false);
        boolean printJson = ConfigTools3.getBoolean((String)"mfc.es.search.req.log.enabled", (boolean)false);
        if (printJson) {
            logger.info("[ESSearchApi][searchWithScroll] queryJson[{}]", (Object)queryJson);
        }
        logger.debug("[ESSearchApi][searchWithScroll] queryJson[{}]", (Object)queryJson);
        logger.debug("[ESSearchApi][searchWithScroll] parseParameter[{}]", (Object)(System.currentTimeMillis() - beginTime));
        try {
            NStringEntity entity = new NStringEntity(queryJson, ContentType.APPLICATION_JSON);
            Request request = new Request("POST", "/" + parameter.getIndex() + "/" + parameter.getType() + "/_search?scroll=" + timeLimit);
            request.setEntity((HttpEntity)entity);
            Response response = this.lowClient.performRequest(request);
            logger.debug("[ESSearchApi][searchWithScroll] performRequest[{}]", (Object)(System.currentTimeMillis() - beginTime));
            beginTime = System.currentTimeMillis();
            NamedXContentRegistry registry = new NamedXContentRegistry(Stream.of(this.getDefaultNamedXContents().stream()).flatMap(Function.identity()).collect(Collectors.toList()));
            SearchResponse searchResponse = SearchResponse.fromXContent((XContentParser)JsonXContent.jsonXContent.createParser(registry, DEPRECATION_HANDLER, response.getEntity().getContent()));
            logger.debug("[ESSearchApi][searchWithScroll] parseContent[{}]", (Object)(System.currentTimeMillis() - beginTime));
            beginTime = System.currentTimeMillis();
            ESApiResponse esApiResponse = this.toResponse(searchResponse);
            TimeStatisticsTools.addTime((String)String.format("ES-respToObject", new Object[0]), (int)1, (long)(System.currentTimeMillis() - beginTime));
            logger.debug("[ESSearchApi][searchWithScroll] parseObject[{}]", (Object)(System.currentTimeMillis() - beginTime));
            return esApiResponse;
        }
        catch (IOException e) {
            logger.error("[ESSearchApi][searchWithScroll] exception,", (Throwable)e);
            return null;
        }
    }

    public <T> ESApiResponse<T> scroll(String scrollId, String timeLimit) {
        long beginTime = System.currentTimeMillis();
        String queryJson = "{\"scroll\":\"" + timeLimit + "\",\"scroll_id\":\"" + scrollId + "\"}";
        logger.debug("[ESSearchApi][searchWithScroll] queryJson[{}]", (Object)queryJson);
        logger.debug("[ESSearchApi][searchWithScroll] parseParameter[{}]", (Object)(System.currentTimeMillis() - beginTime));
        try {
            NStringEntity entity = new NStringEntity(queryJson, ContentType.APPLICATION_JSON);
            Request request = new Request("POST", "/_search/scroll");
            request.setEntity((HttpEntity)entity);
            Response response = this.lowClient.performRequest(request);
            logger.debug("[ESSearchApi][searchWithScroll] performRequest[{}]", (Object)(System.currentTimeMillis() - beginTime));
            beginTime = System.currentTimeMillis();
            NamedXContentRegistry registry = new NamedXContentRegistry(Stream.of(this.getDefaultNamedXContents().stream()).flatMap(Function.identity()).collect(Collectors.toList()));
            SearchResponse searchResponse = SearchResponse.fromXContent((XContentParser)JsonXContent.jsonXContent.createParser(registry, DEPRECATION_HANDLER, response.getEntity().getContent()));
            logger.debug("[ESSearchApi][searchWithScroll] parseContent[{}]", (Object)(System.currentTimeMillis() - beginTime));
            beginTime = System.currentTimeMillis();
            ESApiResponse esApiResponse = this.toResponse(searchResponse);
            TimeStatisticsTools.addTime((String)String.format("ES-respToObject", new Object[0]), (int)1, (long)(System.currentTimeMillis() - beginTime));
            logger.debug("[ESSearchApi][searchWithScroll] parseObject[{}]", (Object)(System.currentTimeMillis() - beginTime));
            return esApiResponse;
        }
        catch (IOException e) {
            logger.error("[ESSearchApi][searchWithScroll] exception,", (Throwable)e);
            return null;
        }
    }

    public boolean clearScroll(String scrollId) {
        long beginTime = System.currentTimeMillis();
        logger.debug("[ESSearchApi][clearScroll] parseParameter[{}]", (Object)(System.currentTimeMillis() - beginTime));
        try {
            Request request = new Request("DELETE", "/_search/scroll/" + scrollId);
            Response response = this.lowClient.performRequest(request);
            logger.debug("[ESSearchApi][clearScroll] performRequest[{}]", (Object)(System.currentTimeMillis() - beginTime));
            beginTime = System.currentTimeMillis();
            Map<String, Object> result = JacksonUtils.parse2Map(response.getEntity().getContent());
            logger.debug("[ESSearchApi][clearScroll] parseContent[{}]", (Object)(System.currentTimeMillis() - beginTime));
            if (result.containsKey("succeeded")) {
                return (Boolean)result.get("succeeded");
            }
            return false;
        }
        catch (IOException e) {
            logger.error("[ESSearchApi][clearScroll] exception,", (Throwable)e);
            return false;
        }
    }

    public SearchResponse searchResponse(SearchSourceBuilder searchSourceBuilder, String index, String type) {
        long beginTime = System.currentTimeMillis();
        boolean printJson = ConfigTools3.getBoolean((String)"mfc.es.search.req.log.enabled", (boolean)false);
        if (printJson) {
            logger.info("[ESSearchApi][searchId] queryJson[{}]", (Object)searchSourceBuilder.toString());
        }
        logger.debug("[ESSearchApi][searchId] queryJson[{}]", (Object)searchSourceBuilder.toString());
        logger.debug("[ESSearchApi][searchId] parseParameter[{}]", (Object)(System.currentTimeMillis() - beginTime));
        try {
            SearchRequest request = new SearchRequest(new String[]{index});
            request.source(searchSourceBuilder);
            request.types(new String[]{type});
            SearchResponse searchResponse = this.client.search(request, RequestOptions.DEFAULT);
            logger.debug("[ESSearchApi][searchId] performRequest[{}]", (Object)(System.currentTimeMillis() - beginTime));
            TimeStatisticsTools.addTime((String)"ES-highLevelResp", (int)1, (long)(System.currentTimeMillis() - beginTime));
            logger.debug("[ESSearchApi][searchResponse] parseId[{}]", (Object)(System.currentTimeMillis() - beginTime));
            return searchResponse;
        }
        catch (IOException e) {
            logger.error("[ESSearchApi][searchResponse] exception,", (Throwable)e);
            return null;
        }
    }

    public ESIdResponse searchId(ESSearchParameter parameter) {
        long beginTime = System.currentTimeMillis();
        String queryJson = this.parseParameter(parameter, true);
        boolean printJson = ConfigTools3.getBoolean((String)"mfc.es.search.req.log.enabled", (boolean)false);
        if (printJson) {
            logger.info("[ESSearchApi][searchId] queryJson[{}]", (Object)queryJson);
        }
        logger.debug("[ESSearchApi][searchId] queryJson[{}]", (Object)queryJson);
        logger.debug("[ESSearchApi][searchId] parseParameter[{}]", (Object)(System.currentTimeMillis() - beginTime));
        try {
            NStringEntity entity = new NStringEntity(queryJson, ContentType.APPLICATION_JSON);
            Request request = new Request("POST", "/" + parameter.getIndex() + "/" + parameter.getType() + "/_search");
            request.setEntity((HttpEntity)entity);
            Response response = this.lowClient.performRequest(request);
            logger.debug("[ESSearchApi][searchId] performRequest[{}]", (Object)(System.currentTimeMillis() - beginTime));
            beginTime = System.currentTimeMillis();
            NamedXContentRegistry registry = new NamedXContentRegistry(Stream.of(this.getDefaultNamedXContents().stream()).flatMap(Function.identity()).collect(Collectors.toList()));
            SearchResponse searchResponse = SearchResponse.fromXContent((XContentParser)JsonXContent.jsonXContent.createParser(registry, DEPRECATION_HANDLER, response.getEntity().getContent()));
            logger.debug("[ESSearchApi][searchId] parseContent[{}]", (Object)(System.currentTimeMillis() - beginTime));
            beginTime = System.currentTimeMillis();
            ESIdResponse esApiResponse = this.toId(searchResponse);
            TimeStatisticsTools.addTime((String)String.format("ES-respToId", new Object[0]), (int)1, (long)(System.currentTimeMillis() - beginTime));
            logger.debug("[ESSearchApi][searchId] parseId[{}]", (Object)(System.currentTimeMillis() - beginTime));
            return esApiResponse;
        }
        catch (IOException e) {
            logger.error("[ESSearchApi][searchId] exception,", (Throwable)e);
            return null;
        }
    }

    private String parseParameter(ESSearchParameter parameter, boolean onlyId) {
        Object queryBuilder;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        ArrayList esNestedFilterBuilders = Lists.newArrayList();
        FunctionScoreQueryBuilder functionQuery = null;
        if (parameter.getFunctionQuery() != null) {
            ESFunctionQueryParameter query = parameter.getFunctionQuery();
            Script script = new Script(query.getScript());
            queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termsQuery((String)query.getFiled(), query.getValues()));
            functionQuery = QueryBuilders.functionScoreQuery((QueryBuilder)queryBuilder, (ScoreFunctionBuilder)new ScriptScoreFunctionBuilder(script)).boostMode(CombineFunction.MULTIPLY);
        }
        block5: for (IESFilterBuilder e2 : parameter.getFilters()) {
            queryBuilder = null;
            EESFilterType esFilterType = EESFilterType.MUST;
            if (e2 instanceof ESTermFilterBuilder) {
                ESTermFilterBuilder termFilter = (ESTermFilterBuilder)e2;
                if (termFilter.getValue() == null && termFilter.getValues() == null) continue;
                queryBuilder = termFilter.isMultiValue() ? QueryBuilders.termsQuery((String)termFilter.getFieldName(), (Collection)termFilter.getValues()) : QueryBuilders.termQuery((String)termFilter.getFieldName(), (Object)termFilter.getValue());
                esFilterType = termFilter.getFilterType();
            } else if (e2 instanceof ESTextFilterBuilder) {
                ESTextFilterBuilder textFilter = (ESTextFilterBuilder)e2;
                if (textFilter.getValue() == null) continue;
                queryBuilder = QueryBuilders.matchQuery((String)textFilter.getFieldName(), (Object)textFilter.getValue()).operator(textFilter.getOperator());
                esFilterType = textFilter.getFilterType();
            } else if (e2 instanceof ESRangeFilterBuilder) {
                ESRangeFilterBuilder rangeFilter = (ESRangeFilterBuilder)e2;
                queryBuilder = QueryBuilders.rangeQuery((String)rangeFilter.getFieldName()).from(rangeFilter.getFrom()).to(rangeFilter.getTo()).includeLower(rangeFilter.isIncludeLower()).includeUpper(rangeFilter.isIncludeUpper());
                esFilterType = rangeFilter.getFilterType();
            } else if (e2 instanceof ESNestedFilterBuilder) {
                ESNestedFilterBuilder nestedFilterBuilder = (ESNestedFilterBuilder)e2;
                queryBuilder = QueryBuilders.nestedQuery((String)nestedFilterBuilder.getPath(), (QueryBuilder)nestedFilterBuilder.getBoolQueryBuilder(), (ScoreMode)nestedFilterBuilder.getScoreMode());
                esFilterType = nestedFilterBuilder.getFilterType();
                esNestedFilterBuilders.add(nestedFilterBuilder);
            }
            if (queryBuilder == null) continue;
            switch (esFilterType) {
                case MUST: {
                    boolQueryBuilder.must((QueryBuilder)queryBuilder);
                    continue block5;
                }
                case MUST_NOT: {
                    boolQueryBuilder.mustNot((QueryBuilder)queryBuilder);
                    continue block5;
                }
                case SHOULD: {
                    boolQueryBuilder.should((QueryBuilder)queryBuilder);
                    continue block5;
                }
            }
            boolQueryBuilder.must((QueryBuilder)queryBuilder);
        }
        if (!parameter.isShowAll() && parameter.getShowUntilDate() > 0) {
            BoolQueryBuilder queryBuilder2 = QueryBuilders.boolQuery();
            queryBuilder2.should((QueryBuilder)QueryBuilders.rangeQuery((String)"releaseDateInt").lt((Object)parameter.getShowUntilDate()));
            queryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"connected", (int)1));
            boolQueryBuilder.must((QueryBuilder)queryBuilder2);
        }
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        if (parameter.isWithFilter()) {
            BoolQueryBuilder filterBuilder = QueryBuilders.boolQuery();
            if (functionQuery != null) {
                filterBuilder.should(functionQuery);
            }
            filterBuilder.filter((QueryBuilder)boolQueryBuilder);
            searchSourceBuilder.query((QueryBuilder)filterBuilder);
        } else {
            if (functionQuery != null) {
                boolQueryBuilder.should(functionQuery);
            }
            searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
        }
        searchSourceBuilder.explain(Boolean.valueOf(false));
        searchSourceBuilder.from(parameter.getFrom());
        searchSourceBuilder.size(parameter.getSize());
        if (parameter.getHighlightFileds().size() != 0) {
            HighlightBuilder highlightBuilder = new HighlightBuilder();
            for (int i = 0; i < parameter.getHighlightFileds().size(); ++i) {
                highlightBuilder.field(parameter.getHighlightFileds().get(i));
            }
            highlightBuilder.numOfFragments(Integer.valueOf(0));
            searchSourceBuilder.highlighter(highlightBuilder);
        }
        parameter.getOrders().forEach(e -> {
            SortOrder order;
            SortOrder sortOrder = order = e.isAscending() ? SortOrder.ASC : SortOrder.DESC;
            if (e.getSource().equals("_score")) {
                ScoreSortBuilder scoreSortBuilder = (ScoreSortBuilder)SortBuilders.scoreSort().order(order);
                searchSourceBuilder.sort((SortBuilder)scoreSortBuilder);
            } else {
                FieldSortBuilder fieldSortBuilder = (FieldSortBuilder)SortBuilders.fieldSort((String)e.getSource()).order(order);
                if (StringUtils.isNotEmpty((CharSequence)e.getNestedPath())) {
                    fieldSortBuilder.setNestedPath(e.getNestedPath());
                    List<ESNestedFilterBuilder> sortESNestedFilterBuilders = esNestedFilterBuilders.stream().filter(nf -> nf.getPath().equals(e.getNestedPath())).collect(Collectors.toList());
                    BoolQueryBuilder sortBoolQueryBuilder = QueryBuilders.boolQuery();
                    sortESNestedFilterBuilders.forEach(snf -> {
                        if (snf.getFilterType() != null) {
                            switch (snf.getFilterType()) {
                                case MUST: {
                                    sortBoolQueryBuilder.must((QueryBuilder)snf.getBoolQueryBuilder());
                                    break;
                                }
                                case MUST_NOT: {
                                    sortBoolQueryBuilder.mustNot((QueryBuilder)snf.getBoolQueryBuilder());
                                    break;
                                }
                                case SHOULD: {
                                    sortBoolQueryBuilder.should((QueryBuilder)snf.getBoolQueryBuilder());
                                    break;
                                }
                                default: {
                                    sortBoolQueryBuilder.must((QueryBuilder)snf.getBoolQueryBuilder());
                                }
                            }
                        }
                    });
                    fieldSortBuilder.setNestedFilter((QueryBuilder)sortBoolQueryBuilder);
                }
                searchSourceBuilder.sort((SortBuilder)fieldSortBuilder);
            }
        });
        if (onlyId) {
            searchSourceBuilder.fetchSource("_id", null);
        }
        return searchSourceBuilder.toString();
    }

    private ESIdResponse toId(SearchResponse searchResponse) {
        ESIdResponse response = new ESIdResponse();
        if (searchResponse != null) {
            response.setTookTime(searchResponse.getTook().getMillis());
            response.setHitTotal(searchResponse.getHits().getTotalHits());
            response.setHitCount(searchResponse.getHits().getHits().length);
            long curTS = System.currentTimeMillis();
            for (SearchHit searchHit : searchResponse.getHits().getHits()) {
                String id = searchHit.getId();
                response.getSource().add(id);
                Map highlightFieldMap = searchHit.getHighlightFields();
                if (CollectionUtils.isNullOrEmpty((Map)highlightFieldMap)) continue;
                LinkedHashMap highlightMap = new LinkedHashMap();
                for (Map.Entry e : highlightFieldMap.entrySet()) {
                    Text[] texts = ((HighlightField)e.getValue()).getFragments();
                    if (texts == null) continue;
                    ArrayList<String> values = new ArrayList<String>();
                    for (int i = 0; i < texts.length; ++i) {
                        Text text = texts[i];
                        String str = text.toString();
                        if (StringUtils.isEmpty((CharSequence)str)) continue;
                        values.add(str);
                    }
                    highlightMap.put(e.getKey(), values);
                }
                response.getHighlights().put(id, highlightMap);
            }
            TimeStatisticsTools.addTime((String)String.format("ES-SEARCH-API:SEARCH:ID", new Object[0]), (int)searchResponse.getHits().getHits().length, (long)(System.currentTimeMillis() - curTS));
        }
        return response;
    }

    public <T> ESApiResponse<T> getDocumentByIds(String index, String type, Set<String> docIds) {
        MultiGetRequest mgetRequest = new MultiGetRequest();
        docIds.forEach(e -> mgetRequest.add(index, type, e));
        try {
            MultiGetResponse multiGetResponse = this.client.multiGet(mgetRequest, new Header[0]);
            return this.toResponse(multiGetResponse);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        ESSearchParameter parameter = ESSearchParameter.builder().index("media_detail").type("media_detail").size(10000).add(ESTermFilterBuilder.builder("seriesId").setValue(19870832));
    }
}

