/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.es.api.model.service.search;

import com.valor.vod.es.api.client.EESFilterType;
import com.valor.vod.es.api.model.service.base.AbstractPrintable;
import com.valor.vod.es.api.model.service.search.ESRangeFilterBuilder;
import com.valor.vod.es.api.model.service.search.ESTermFilterBuilder;
import com.valor.vod.es.api.model.service.search.IESFilterBuilder;
import java.util.Collection;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermsQueryBuilder;

public class ESNestedFilterBuilder
extends AbstractPrintable
implements IESFilterBuilder {
    private final String path;
    BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
    ScoreMode scoreMode;
    private EESFilterType filterType = EESFilterType.MUST;

    public static ESNestedFilterBuilder builder(String path) {
        return ESNestedFilterBuilder.builder(path, ScoreMode.None);
    }

    public static ESNestedFilterBuilder builder(String path, ScoreMode scoreMod) {
        return new ESNestedFilterBuilder(path, scoreMod);
    }

    public ESNestedFilterBuilder(String path, ScoreMode scoreMode) {
        this.path = path;
        this.scoreMode = scoreMode;
    }

    public ESNestedFilterBuilder add(IESFilterBuilder IESFilterBuilder2) {
        TermsQueryBuilder queryBuilder = null;
        EESFilterType esFilterType = EESFilterType.MUST;
        if (IESFilterBuilder2 instanceof ESTermFilterBuilder) {
            ESTermFilterBuilder termFilter = (ESTermFilterBuilder)IESFilterBuilder2;
            if (termFilter.isMultiValue() && termFilter.getValues() != null) {
                queryBuilder = QueryBuilders.termsQuery((String)termFilter.getFieldName(), (Collection)termFilter.getValues());
            } else if (!termFilter.isMultiValue() && termFilter.getValue() != null) {
                queryBuilder = QueryBuilders.termQuery((String)termFilter.getFieldName(), (Object)termFilter.getValue());
            }
            esFilterType = termFilter.getFilterType();
        } else if (IESFilterBuilder2 instanceof ESRangeFilterBuilder) {
            ESRangeFilterBuilder rangeFilter = (ESRangeFilterBuilder)IESFilterBuilder2;
            queryBuilder = QueryBuilders.rangeQuery((String)rangeFilter.getFieldName()).from(rangeFilter.getFrom()).to(rangeFilter.getTo()).includeLower(rangeFilter.isIncludeLower()).includeUpper(rangeFilter.isIncludeUpper());
            esFilterType = rangeFilter.getFilterType();
        }
        if (queryBuilder != null) {
            switch (esFilterType) {
                case MUST: {
                    this.boolQueryBuilder.must(queryBuilder);
                    break;
                }
                case SHOULD: {
                    this.boolQueryBuilder.should(queryBuilder);
                    break;
                }
                case MUST_NOT: {
                    this.boolQueryBuilder.mustNot(queryBuilder);
                    break;
                }
                default: {
                    this.boolQueryBuilder.must(queryBuilder);
                }
            }
        }
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public BoolQueryBuilder getBoolQueryBuilder() {
        return this.boolQueryBuilder;
    }

    public ScoreMode getScoreMode() {
        return this.scoreMode;
    }

    public ESNestedFilterBuilder setFilterType(EESFilterType filterType) {
        this.filterType = filterType;
        return this;
    }

    public EESFilterType getFilterType() {
        return this.filterType;
    }
}

