/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.es.api.model.service.search;

import com.google.common.collect.Sets;
import com.valor.vod.es.api.model.service.base.AbstractPrintable;
import com.valor.vod.es.api.model.service.search.ESFunctionQueryParameter;
import com.valor.vod.es.api.model.service.search.ESOrder;
import com.valor.vod.es.api.model.service.search.IESFilterBuilder;
import common.config.tools.config.ConfigTools3;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ESSearchParameter
extends AbstractPrintable {
    private String index;
    private String type;
    private int from;
    private int size;
    private Set<IESFilterBuilder> filters = Sets.newLinkedHashSet();
    private Set<ESOrder> orders = Sets.newLinkedHashSet();
    private boolean showAll = false;
    private int showUntilDate = 0;
    private boolean unLimitSize = false;
    private List<String> highlightFileds = new ArrayList<String>();
    private boolean withFilter = true;
    private ESFunctionQueryParameter functionQuery;

    public static ESSearchParameter builder() {
        return new ESSearchParameter();
    }

    public ESSearchParameter index(String index) {
        this.index = index;
        return this;
    }

    public ESSearchParameter type(String type) {
        this.type = type;
        return this;
    }

    public ESSearchParameter from(int from) {
        this.from = from;
        return this;
    }

    public ESSearchParameter size(int size) {
        this.size = size;
        return this;
    }

    public ESSearchParameter add(IESFilterBuilder filter) {
        this.filters.add(filter);
        return this;
    }

    public ESSearchParameter add(ESOrder order) {
        this.orders.add(order);
        return this;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public int getFrom() {
        if (this.unLimitSize) {
            return this.from;
        }
        int max = ConfigTools3.getInt((String)"es.max.result", (Integer)10000);
        return Math.min(max, this.from);
    }

    public int getSize() {
        if (this.unLimitSize) {
            return this.size;
        }
        int max = ConfigTools3.getInt((String)"es.max.result", (Integer)10000);
        return Math.min(max, this.size);
    }

    public Set<IESFilterBuilder> getFilters() {
        return this.filters;
    }

    public Set<ESOrder> getOrders() {
        return this.orders;
    }

    public boolean isShowAll() {
        return this.showAll;
    }

    public int getShowUntilDate() {
        return this.showUntilDate;
    }

    public void setIndex(String index) {
        this.index = index;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setFrom(int from) {
        this.from = from;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setFilters(Set<IESFilterBuilder> filters) {
        this.filters = filters;
    }

    public void setOrders(Set<ESOrder> orders) {
        this.orders = orders;
    }

    public void setShowAll(boolean showAll) {
        this.showAll = showAll;
    }

    public void setShowUntilDate(int showUntilDate) {
        this.showUntilDate = showUntilDate;
    }

    public void setUnLimitSize(boolean unLimitSize) {
        this.unLimitSize = unLimitSize;
    }

    public List<String> getHighlightFileds() {
        return this.highlightFileds;
    }

    public void setHighlightFileds(List<String> highlightFileds) {
        this.highlightFileds = highlightFileds;
    }

    public boolean isWithFilter() {
        return this.withFilter;
    }

    public void setWithFilter(boolean withFilter) {
        this.withFilter = withFilter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ESSearchParameter)) {
            return false;
        }
        ESSearchParameter other = (ESSearchParameter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getFrom() != other.getFrom()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.isShowAll() != other.isShowAll()) {
            return false;
        }
        if (this.getShowUntilDate() != other.getShowUntilDate()) {
            return false;
        }
        if (this.isUnLimitSize() != other.isUnLimitSize()) {
            return false;
        }
        if (this.isWithFilter() != other.isWithFilter()) {
            return false;
        }
        String this$index = this.getIndex();
        String other$index = other.getIndex();
        if (this$index == null ? other$index != null : !this$index.equals(other$index)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Set<IESFilterBuilder> this$filters = this.getFilters();
        Set<IESFilterBuilder> other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !((Object)this$filters).equals(other$filters)) {
            return false;
        }
        Set<ESOrder> this$orders = this.getOrders();
        Set<ESOrder> other$orders = other.getOrders();
        if (this$orders == null ? other$orders != null : !((Object)this$orders).equals(other$orders)) {
            return false;
        }
        List<String> this$highlightFileds = this.getHighlightFileds();
        List<String> other$highlightFileds = other.getHighlightFileds();
        if (this$highlightFileds == null ? other$highlightFileds != null : !((Object)this$highlightFileds).equals(other$highlightFileds)) {
            return false;
        }
        ESFunctionQueryParameter this$functionQuery = this.getFunctionQuery();
        ESFunctionQueryParameter other$functionQuery = other.getFunctionQuery();
        return !(this$functionQuery == null ? other$functionQuery != null : !((Object)this$functionQuery).equals(other$functionQuery));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ESSearchParameter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getFrom();
        result = result * 59 + this.getSize();
        result = result * 59 + (this.isShowAll() ? 79 : 97);
        result = result * 59 + this.getShowUntilDate();
        result = result * 59 + (this.isUnLimitSize() ? 79 : 97);
        result = result * 59 + (this.isWithFilter() ? 79 : 97);
        String $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : $index.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Set<IESFilterBuilder> $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : ((Object)$filters).hashCode());
        Set<ESOrder> $orders = this.getOrders();
        result = result * 59 + ($orders == null ? 43 : ((Object)$orders).hashCode());
        List<String> $highlightFileds = this.getHighlightFileds();
        result = result * 59 + ($highlightFileds == null ? 43 : ((Object)$highlightFileds).hashCode());
        ESFunctionQueryParameter $functionQuery = this.getFunctionQuery();
        result = result * 59 + ($functionQuery == null ? 43 : ((Object)$functionQuery).hashCode());
        return result;
    }

    public boolean isUnLimitSize() {
        return this.unLimitSize;
    }

    public ESFunctionQueryParameter getFunctionQuery() {
        return this.functionQuery;
    }

    public void setFunctionQuery(ESFunctionQueryParameter functionQuery) {
        this.functionQuery = functionQuery;
    }

    @Override
    public String toString() {
        return "ESSearchParameter(index=" + this.getIndex() + ", type=" + this.getType() + ", from=" + this.getFrom() + ", size=" + this.getSize() + ", filters=" + this.getFilters() + ", orders=" + this.getOrders() + ", showAll=" + this.isShowAll() + ", showUntilDate=" + this.getShowUntilDate() + ", unLimitSize=" + this.isUnLimitSize() + ", highlightFileds=" + this.getHighlightFileds() + ", withFilter=" + this.isWithFilter() + ", functionQuery=" + this.getFunctionQuery() + ")";
    }
}

