/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.es.api.client;

import com.amazonaws.auth.AWS4Signer;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.Signer;
import com.amazonaws.http.AWSRequestSigningApacheInterceptor;
import com.google.common.collect.Lists;
import com.valor.vod.es.api.client.ESIndexApi;
import com.valor.vod.es.api.model.YmlIndex;
import com.valor.vod.es.api.model.client.ESProperties;
import com.valor.vod.es.api.model.service.base.IDocument;
import com.valor.vod.es.api.model.service.cloud.MediaCloud;
import com.valor.vod.es.api.model.service.cloud.MediaCloudSearchIndex;
import com.valor.vod.es.api.model.service.media.MediaAward;
import com.valor.vod.es.api.model.service.media.MediaBase;
import com.valor.vod.es.api.model.service.media.MediaDetail;
import com.valor.vod.es.api.model.service.media.MediaImage;
import com.valor.vod.es.api.model.service.media.MediaParentsGuide;
import com.valor.vod.es.api.model.service.media.MediaSearchIndex;
import com.valor.vod.es.api.model.service.media.MediaSummary;
import com.valor.vod.es.api.model.service.media.MediaSynopsis;
import com.valor.vod.es.api.model.service.media.MediaTextIndex;
import com.valor.vod.es.api.model.service.media.MediaUserReview;
import com.valor.vod.es.api.model.service.person.Person;
import com.valor.vod.es.api.model.service.person.PersonSearchIndex;
import com.valor.vod.es.api.model.service.playlist.PlaylistNodeIndex;
import com.valor.vod.es.api.model.service.search.ESApiResponse;
import com.valor.vod.es.api.tools.JacksonUtils;
import common.base.tools.stat.TimeStatisticsTools;
import common.config.tools.config.ConfigTools3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ContextParser;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.adjacency.ParsedAdjacencyMatrix;
import org.elasticsearch.search.aggregations.bucket.composite.ParsedComposite;
import org.elasticsearch.search.aggregations.bucket.filter.ParsedFilter;
import org.elasticsearch.search.aggregations.bucket.filter.ParsedFilters;
import org.elasticsearch.search.aggregations.bucket.geogrid.ParsedGeoHashGrid;
import org.elasticsearch.search.aggregations.bucket.global.ParsedGlobal;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedHistogram;
import org.elasticsearch.search.aggregations.bucket.missing.ParsedMissing;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedNested;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedReverseNested;
import org.elasticsearch.search.aggregations.bucket.range.ParsedBinaryRange;
import org.elasticsearch.search.aggregations.bucket.range.ParsedDateRange;
import org.elasticsearch.search.aggregations.bucket.range.ParsedGeoDistance;
import org.elasticsearch.search.aggregations.bucket.range.ParsedRange;
import org.elasticsearch.search.aggregations.bucket.sampler.ParsedSampler;
import org.elasticsearch.search.aggregations.bucket.significant.ParsedSignificantLongTerms;
import org.elasticsearch.search.aggregations.bucket.significant.ParsedSignificantStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedDoubleTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.metrics.avg.ParsedAvg;
import org.elasticsearch.search.aggregations.metrics.cardinality.ParsedCardinality;
import org.elasticsearch.search.aggregations.metrics.geobounds.ParsedGeoBounds;
import org.elasticsearch.search.aggregations.metrics.geocentroid.ParsedGeoCentroid;
import org.elasticsearch.search.aggregations.metrics.max.ParsedMax;
import org.elasticsearch.search.aggregations.metrics.min.ParsedMin;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.ParsedHDRPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.percentiles.hdr.ParsedHDRPercentiles;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.ParsedTDigestPercentileRanks;
import org.elasticsearch.search.aggregations.metrics.percentiles.tdigest.ParsedTDigestPercentiles;
import org.elasticsearch.search.aggregations.metrics.scripted.ParsedScriptedMetric;
import org.elasticsearch.search.aggregations.metrics.stats.ParsedStats;
import org.elasticsearch.search.aggregations.metrics.stats.extended.ParsedExtendedStats;
import org.elasticsearch.search.aggregations.metrics.sum.ParsedSum;
import org.elasticsearch.search.aggregations.metrics.tophits.ParsedTopHits;
import org.elasticsearch.search.aggregations.metrics.valuecount.ParsedValueCount;
import org.elasticsearch.search.aggregations.pipeline.ParsedSimpleValue;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.ParsedBucketMetricValue;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.percentile.ParsedPercentilesBucket;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.ParsedStatsBucket;
import org.elasticsearch.search.aggregations.pipeline.bucketmetrics.stats.extended.ParsedExtendedStatsBucket;
import org.elasticsearch.search.aggregations.pipeline.derivative.ParsedDerivative;
import org.elasticsearch.search.suggest.Suggest;
import org.elasticsearch.search.suggest.completion.CompletionSuggestion;
import org.elasticsearch.search.suggest.phrase.PhraseSuggestion;
import org.elasticsearch.search.suggest.term.TermSuggestion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESApi {
    private static final Logger logger = LoggerFactory.getLogger(ESIndexApi.class);
    protected RestClient lowClient = null;
    protected RestHighLevelClient client = null;
    protected boolean bInit = false;
    protected ESProperties properties = null;
    protected static final DeprecationHandler DEPRECATION_HANDLER = new DeprecationHandler(){

        public void usedDeprecatedName(String usedName, String modernName) {
        }

        public void usedDeprecatedField(String usedName, String replacedWith) {
        }
    };

    public ESApi(ESProperties properties) {
        this.properties = properties;
        this.bInit = this.init();
    }

    public boolean init() {
        if (this.bInit && this.client != null) {
            return this.bInit;
        }
        logger.info("[ES-API]Connect[{}://{}:{}]", new Object[]{this.properties.getHost(), this.properties.getPort(), this.properties.getProtocol()});
        ArrayList hosts = Lists.newArrayList();
        this.properties.getHost().forEach(e -> hosts.add(new HttpHost(e, this.properties.getPort(), this.properties.getProtocol())));
        HttpHost[] hostArray = new HttpHost[this.properties.getHost().size()];
        hostArray = hosts.toArray(hostArray);
        RestClientBuilder restClientBuilder = null;
        if (StringUtils.isNotEmpty((CharSequence)this.properties.getUserName())) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.properties.getUserName(), this.properties.getPassword()));
            if (StringUtils.isNotEmpty((CharSequence)this.properties.getServerName()) && this.properties.getServerName().equalsIgnoreCase("aliyun")) {
                restClientBuilder = RestClient.builder((HttpHost[])hostArray).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                    final /* synthetic */ CredentialsProvider val$credentialsProvider;
                    {
                        this.val$credentialsProvider = credentialsProvider;
                    }

                    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                        return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                    }
                });
                this.lowClient = restClientBuilder.build();
                this.client = new RestHighLevelClient(restClientBuilder);
            } else {
                restClientBuilder = RestClient.builder((HttpHost[])hostArray).setMaxRetryTimeoutMillis(300000).setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback((CredentialsProvider)credentialsProvider){
                    final /* synthetic */ CredentialsProvider val$credentialsProvider;
                    {
                        this.val$credentialsProvider = credentialsProvider;
                    }

                    public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder httpClientBuilder) {
                        return httpClientBuilder.setDefaultCredentialsProvider(this.val$credentialsProvider);
                    }
                });
                AWS4Signer signer = new AWS4Signer();
                signer.setServiceName(ConfigTools3.getString((String)"mfc.es.cluster.server.AWS4SignerServiceName", (String)"es"));
                signer.setRegionName(ConfigTools3.getString((String)"mfc.es.cluster.server.AWS4SignerRegionName", (String)"cn-northwest-1"));
                BasicAWSCredentials awsCreds = new BasicAWSCredentials(this.properties.getUserName(), this.properties.getPassword());
                AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCreds);
                AWSRequestSigningApacheInterceptor interceptor = new AWSRequestSigningApacheInterceptor("es", (Signer)signer, (AWSCredentialsProvider)awsCredentialsProvider);
                this.lowClient = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.properties.getHost().get(0), this.properties.getPort(), this.properties.getProtocol())}).setHttpClientConfigCallback(hacb -> hacb.addInterceptorLast(interceptor)).build();
                this.client = new RestHighLevelClient(RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.properties.getHost().get(0), this.properties.getPort(), this.properties.getProtocol())}).setHttpClientConfigCallback(hacb -> hacb.addInterceptorLast(interceptor)));
            }
        } else {
            restClientBuilder = RestClient.builder((HttpHost[])hostArray);
            this.lowClient = restClientBuilder.build();
            this.client = new RestHighLevelClient(restClientBuilder);
        }
        return this.client != null;
    }

    public boolean hasInit() {
        return this.bInit;
    }

    public String toJson(IDocument doc) {
        try {
            return JacksonUtils.toJson(doc);
        }
        catch (Exception e) {
            logger.info("[ES-API]To json failed. doc:[{}] ex:[{}]", (Object)doc, (Object)e);
            return "";
        }
    }

    public <T> T fromJsonStr(String jsonStr, Class<T> clazz) {
        try {
            return JacksonUtils.toObj(jsonStr, clazz);
        }
        catch (Exception e) {
            logger.info("[ES-API]From json failed. doc:[{}] ex:[{}]", (Object)jsonStr, (Object)e);
            return null;
        }
    }

    protected List<NamedXContentRegistry.Entry> getDefaultNamedXContents() {
        HashMap<String, ContextParser> map = new HashMap<String, ContextParser>();
        map.put("cardinality", (p, c) -> ParsedCardinality.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("hdr_percentiles", (p, c) -> ParsedHDRPercentiles.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("hdr_percentile_ranks", (p, c) -> ParsedHDRPercentileRanks.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("tdigest_percentiles", (p, c) -> ParsedTDigestPercentiles.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("tdigest_percentile_ranks", (p, c) -> ParsedTDigestPercentileRanks.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("percentiles_bucket", (p, c) -> ParsedPercentilesBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("min", (p, c) -> ParsedMin.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("max", (p, c) -> ParsedMax.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sum", (p, c) -> ParsedSum.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("avg", (p, c) -> ParsedAvg.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("value_count", (p, c) -> ParsedValueCount.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("simple_value", (p, c) -> ParsedSimpleValue.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("derivative", (p, c) -> ParsedDerivative.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("bucket_metric_value", (p, c) -> ParsedBucketMetricValue.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("stats", (p, c) -> ParsedStats.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("stats_bucket", (p, c) -> ParsedStatsBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("extended_stats", (p, c) -> ParsedExtendedStats.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("extended_stats_bucket", (p, c) -> ParsedExtendedStatsBucket.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_bounds", (p, c) -> ParsedGeoBounds.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_centroid", (p, c) -> ParsedGeoCentroid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("histogram", (p, c) -> ParsedHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("date_histogram", (p, c) -> ParsedDateHistogram.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sterms", (p, c) -> ParsedStringTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("lterms", (p, c) -> ParsedLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("dterms", (p, c) -> ParsedDoubleTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("missing", (p, c) -> ParsedMissing.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("nested", (p, c) -> ParsedNested.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("reverse_nested", (p, c) -> ParsedReverseNested.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("global", (p, c) -> ParsedGlobal.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("filter", (p, c) -> ParsedFilter.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sampler", (p, c) -> ParsedSampler.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geohash_grid", (p, c) -> ParsedGeoHashGrid.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("range", (p, c) -> ParsedRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("date_range", (p, c) -> ParsedDateRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("geo_distance", (p, c) -> ParsedGeoDistance.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("filters", (p, c) -> ParsedFilters.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("adjacency_matrix", (p, c) -> ParsedAdjacencyMatrix.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("siglterms", (p, c) -> ParsedSignificantLongTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("sigsterms", (p, c) -> ParsedSignificantStringTerms.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("scripted_metric", (p, c) -> ParsedScriptedMetric.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("ip_range", (p, c) -> ParsedBinaryRange.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("top_hits", (p, c) -> ParsedTopHits.fromXContent((XContentParser)p, (String)((String)c)));
        map.put("composite", (p, c) -> ParsedComposite.fromXContent((XContentParser)p, (String)((String)c)));
        List<NamedXContentRegistry.Entry> entries = map.entrySet().stream().map(entry -> new NamedXContentRegistry.Entry(Aggregation.class, new ParseField((String)entry.getKey(), new String[0]), (ContextParser)entry.getValue())).collect(Collectors.toList());
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("term", new String[0]), (parser, context) -> TermSuggestion.fromXContent((XContentParser)parser, (String)((String)context))));
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("phrase", new String[0]), (parser, context) -> PhraseSuggestion.fromXContent((XContentParser)parser, (String)((String)context))));
        entries.add(new NamedXContentRegistry.Entry(Suggest.Suggestion.class, new ParseField("completion", new String[0]), (parser, context) -> CompletionSuggestion.fromXContent((XContentParser)parser, (String)((String)context))));
        return entries;
    }

    protected <T> ESApiResponse<T> toResponse(MultiGetResponse multiGetResponse) {
        ESApiResponse response = new ESApiResponse();
        if (multiGetResponse != null) {
            for (MultiGetItemResponse itemResponse : multiGetResponse.getResponses()) {
                GetResponse getResponse = itemResponse.getResponse();
                if (!getResponse.isExists()) continue;
                Class<T> valueType = this.getValueType(getResponse.getType());
                T v = this.fromJsonStr(getResponse.getSourceAsString(), valueType);
                response.getSource().add(v);
            }
        }
        return response;
    }

    protected <T> ESApiResponse<T> toResponse(SearchResponse searchResponse) {
        ESApiResponse response = new ESApiResponse();
        if (searchResponse != null) {
            response.setTookTime(searchResponse.getTook().getMillis());
            response.setHitTotal(searchResponse.getHits().getTotalHits());
            response.setHitCount(searchResponse.getHits().getHits().length);
            response.setScrollId(searchResponse.getScrollId());
            long curTS = System.currentTimeMillis();
            for (SearchHit searchHit : searchResponse.getHits().getHits()) {
                Class<T> valueType = this.getValueType(searchHit.getType());
                T v = this.fromJsonStr(searchHit.getSourceAsString(), valueType);
                response.getSource().add(v);
            }
            TimeStatisticsTools.addTime((String)String.format("ES-SEARCH-API:SEARCH:JSON", new Object[0]), (int)searchResponse.getHits().getHits().length, (long)(System.currentTimeMillis() - curTS));
        }
        return response;
    }

    protected <T> Class<T> getValueType(String type) {
        switch (type) {
            case "mediaBase": {
                return MediaBase.class;
            }
            case "mediaSummary": {
                return MediaSummary.class;
            }
            case "media_detail": {
                return MediaDetail.class;
            }
            case "media_user_review": {
                return MediaUserReview.class;
            }
            case "media_synopsis": {
                return MediaSynopsis.class;
            }
            case "media_parents_guide": {
                return MediaParentsGuide.class;
            }
            case "media_image": {
                return MediaImage.class;
            }
            case "person": {
                return Person.class;
            }
            case "media_cloud": {
                return MediaCloud.class;
            }
            case "media_award": {
                return MediaAward.class;
            }
            case "media_search_index": {
                return MediaSearchIndex.class;
            }
            case "media_text_index": {
                return MediaTextIndex.class;
            }
            case "media_cloud_search_index": {
                return MediaCloudSearchIndex.class;
            }
            case "person_search_index": {
                return PersonSearchIndex.class;
            }
            case "yml_index": {
                return YmlIndex.class;
            }
            case "playlist_node": {
                return PlaylistNodeIndex.class;
            }
        }
        return null;
    }
}

