/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.es.api.tools;

import com.alibaba.nacos.common.utils.ByteUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public class JacksonUtils {
    static ObjectMapper mapper = new ObjectMapper();

    public static String toJson(Object obj) {
        try {
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not write JSON", e);
        }
    }

    public static byte[] toJsonBytes(Object obj) {
        try {
            return ByteUtils.toBytes((String)mapper.writeValueAsString(obj));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not toJsonBytes", e);
        }
    }

    public static <T> T toObj(byte[] json, Class<T> cls) {
        try {
            return JacksonUtils.toObj(json, cls);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert JSON to Class", e);
        }
    }

    public static <T> T toObj(byte[] json, Type cls) {
        try {
            return JacksonUtils.toObj(json, cls);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert JSON to Type", e);
        }
    }

    public static <T> T toObj(InputStream inputStream, Class<T> cls) {
        try {
            return (T)mapper.readValue(inputStream, cls);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert inputStream to Class", e);
        }
    }

    public static <T> T toObj(byte[] json, TypeReference<T> typeReference) {
        try {
            return JacksonUtils.toObj(json, typeReference);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to convert json to TypeReference", e);
        }
    }

    public static <T> T toObj(String json, Class<T> cls) {
        try {
            return (T)mapper.readValue(json, cls);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObj(String json, Type type) {
        try {
            return (T)mapper.readValue(json, mapper.constructType(type));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObj(String json, TypeReference<T> typeReference) {
        try {
            return (T)mapper.readValue(json, typeReference);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T toObj(InputStream inputStream, Type type) {
        try {
            return (T)mapper.readValue(inputStream, mapper.constructType(type));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonNode toObj(String json) {
        try {
            return mapper.readTree(json);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerSubtype(Class<?> clz, String type) {
        mapper.registerSubtypes(new NamedType[]{new NamedType(clz, type)});
    }

    public static ObjectNode createEmptyJsonNode() {
        return new ObjectNode(mapper.getNodeFactory());
    }

    public static ArrayNode createEmptyArrayNode() {
        return new ArrayNode(mapper.getNodeFactory());
    }

    public static JsonNode transferToJsonNode(Object obj) {
        return mapper.valueToTree(obj);
    }

    public static Map<String, Object> parse2Map(InputStream is) {
        try {
            return (Map)mapper.readValue(is, HashMap.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

