package com.valor.vod.es.api.model.service.playlist;

import com.valor.vod.es.api.model.service.base.IDocument;
import lombok.Getter;
import lombok.Setter;

/**
 *
 * @author Damon.Gao
 * @date 2022/9/8 17:08
 */
@Getter
@Setter
public class PlaylistNodeIndex implements IDocument {

    private Long id;

    private Long parentPlaylistId;

    private String nodeType;

    private String extra;

    private Long vmsId;

    /**
     * 根节点id
     */
    private Long rootNodeId;

    private Integer sortNo;

    private String type;

    /**
     * 节点生效时间
     */
    private Long startTimeStamp;

    /**
     * 节点失效时间
     */
    private Long endTimeStamp;

    @Override
    public String getDocumentId() {
        return makeDocumentId(rootNodeId, parentPlaylistId, id, type);
    }
}
