package com.valor.vod.es.api.model.service.search;

import com.valor.vod.es.api.client.EESFilterType;
import com.valor.vod.es.api.model.service.base.AbstractPrintable;
import common.config.tools.config.ConfigTools3;
import org.elasticsearch.index.query.Operator;

public class ESTextFilterBuilder extends AbstractPrintable implements IESFilterBuilder {
    private final String fieldName;
    private Object value;
    private EESFilterType filterType = EESFilterType.MUST;
    private Operator operator = Operator.OR;

    public static ESTextFilterBuilder builder(String fieldName) {
        return new ESTextFilterBuilder(fieldName);
    }

    public ESTextFilterBuilder(String fieldName) {
        String oper = ConfigTools3.getString("mfc.searchtext.operator", "or");
        if (oper.equals("and")) {
            operator = Operator.AND;
        }
        this.fieldName = fieldName;
    }

    public ESTextFilterBuilder setValue(Object value) {
        this.value = value;
        return this;
    }


    public ESTextFilterBuilder setFilterType(EESFilterType filterType) {
        this.filterType = filterType;
        return this;
    }

    public String getFieldName() {
        return fieldName;
    }


    public Object getValue() {
        return value;
    }


    public EESFilterType getFilterType() {
        return filterType;
    }

    public Operator getOperator() {
        return operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }
}
