package com.valor.vod.meta.cache.db;

import com.valor.vod.meta.model.database.dao.MetaDao;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistNodeVersionDDO;
import common.base.tools.type.CollectionUtils;
import org.hibernate.SQLQuery;
import org.hibernate.query.NativeQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@Repository
@Transactional(value = "metaTransactionManager")
public class CacheDao extends MetaDao {
    private static final Logger logger = LoggerFactory.getLogger(CacheDao.class);

    public Map<Long, Set<Long>> queryVideoIdsByCids(Set<Long> cidSet) {
        Map<Long, Set<Long>> cidMap = new HashMap<>();
        if (CollectionUtils.isNullOrEmpty(cidSet)) {
            return cidMap;
        }
        StringBuilder inSql = new StringBuilder();
        int i = 0;
        for (Long cid : cidSet) {
            if (i != 0) {
                inSql.append(",");
            }
            inSql.append(cid);
            i++;
        }
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("select cid,video_id from linked_cloud");
        sqlSb.append(" where cid in ( ");
        sqlSb.append(inSql);
        sqlSb.append(" )");
        SQLQuery sqlQuery = currentSession().createSQLQuery(sqlSb.toString());
        Iterator it = sqlQuery.list().iterator();

        while (it.hasNext()) { // 通过循环将查询到的用户信息保存到List集合中
            Object[] o = (Object[]) it.next();
            Long cid = Long.parseLong(o[0].toString());
            Long videoId = Long.parseLong(o[1].toString());
            Set<Long> videoIdSet = null;
            if (cidMap.containsKey(cid)) {
                videoIdSet = cidMap.get(cid);
            } else {
                videoIdSet = new HashSet<>();
                cidMap.put(cid, videoIdSet);
            }
            videoIdSet.add(videoId);
        }
        return cidMap;
    }
}
