package com.valor.vod.meta.cache.model;

import com.valor.vod.es.api.model.service.media.MediaCertification;
import com.valor.vod.es.api.model.service.media.MediaSubtitleInfo;
import com.valor.vod.es.api.model.service.media.Summary;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

//the data for list
public class MediaListSummary {
    protected Long id = -1L;
    protected String metaId;
    private Integer mediaType = 0;
    private String displayId = "";
    private String releaseDate;
    private String originalTitle = "";
    private Double rating = 0.0;
    private Double weightRating = 0.0D;
    private String lastAirDate;
    //private String linkedLastAirDate;
    private Long lastConnectedTime = 0L;
    private Long publishLastModifyTime = 0L;
    private Long runtime = 0L;
    private List<Summary> summaries = new ArrayList<>();
    private Set<Long> genres = new LinkedHashSet();
    private Set<Long> clouds = new LinkedHashSet();

    private Double recommendValue = 0.0D;
    private Long like = 0L;
    private Long unlike = 0L;
    private Long viewedAll = 0L;
    private Long viewedDay = 0L;
    private Long viewedWeek = 0L;
    private Long viewedMonth = 0L;
    private Long viewedYear = 0L;
    private Set<String> cloudsAudioLanguage = new LinkedHashSet();
    private Set<String> subtitles = new LinkedHashSet();
    private Set<MediaSubtitleInfo> subtitleInfos = new LinkedHashSet<>();

    private LinkedHashSet<Long> countries = new LinkedHashSet();
    private List<MediaCertification> certifications = new ArrayList<>();

    private int latestSeason;//tv有资源最后更新season
    private int latestEpisode;//tv有资源最后更新episode
    private int onTheAirAllLatestSeason;//tv ontheair最后更新season
    private int onTheAirAllLatestEpisode;//tv ontheair有资源最后更新episode
    private String linkedLastAirDate;
    private String onTheAirAllLastAirDate;

    private Double popularity = 0.0;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getMetaId() {
        return metaId;
    }

    public void setMetaId(String metaId) {
        this.metaId = metaId;
    }

    public Integer getMediaType() {
        return mediaType;
    }

    public void setMediaType(Integer mediaType) {
        this.mediaType = mediaType;
    }

    public String getDisplayId() {
        return displayId;
    }

    public void setDisplayId(String displayId) {
        this.displayId = displayId;
    }

    public String getReleaseDate() {
        return releaseDate;
    }

    public void setReleaseDate(String releaseDate) {
        this.releaseDate = releaseDate;
    }

    public String getOriginalTitle() {
        return originalTitle;
    }

    public void setOriginalTitle(String originalTitle) {
        this.originalTitle = originalTitle;
    }

    public Double getRating() {
        return rating;
    }

    public void setRating(Double rating) {
        this.rating = rating;
    }

    public String getLastAirDate() {
        return lastAirDate;
    }

    public void setLastAirDate(String lastAirDate) {
        this.lastAirDate = lastAirDate;
    }

    public List<Summary> getSummaries() {
        return summaries;
    }

    public void setSummaries(List<Summary> summaries) {
        this.summaries = summaries;
    }

    public Set<Long> getGenres() {
        return genres;
    }

    public void setGenres(Set<Long> genres) {
        this.genres = genres;
    }

    public Set<Long> getClouds() {
        return clouds;
    }

    public void setClouds(Set<Long> clouds) {
        this.clouds = clouds;
    }

    public Double getWeightRating() {
        return weightRating;
    }

    public void setWeightRating(Double weightRating) {
        this.weightRating = weightRating;
    }

    public Long getRuntime() {
        return runtime;
    }

    public void setRuntime(Long runtime) {
        this.runtime = runtime;
    }

//    public String getLinkedLastAirDate() {

    public Double getRecommendValue() {
        return recommendValue;
    }

    public void setRecommendValue(Double recommendValue) {
        this.recommendValue = recommendValue;
    }

    public Long getLike() {
        return like;
    }

    public void setLike(Long like) {
        this.like = like;
    }

    public Long getUnlike() {
        return unlike;
    }

    public void setUnlike(Long unlike) {
        this.unlike = unlike;
    }

    public Long getViewedAll() {
        return viewedAll;
    }

    public void setViewedAll(Long viewedAll) {
        this.viewedAll = viewedAll;
    }

    public Long getViewedDay() {
        return viewedDay;
    }

    public void setViewedDay(Long viewedDay) {
        this.viewedDay = viewedDay;
    }

    public Long getViewedWeek() {
        return viewedWeek;
    }

    public void setViewedWeek(Long viewedWeek) {
        this.viewedWeek = viewedWeek;
    }

    public Long getViewedMonth() {
        return viewedMonth;
    }

    public void setViewedMonth(Long viewedMonth) {
        this.viewedMonth = viewedMonth;
    }

    public Long getViewedYear() {
        return viewedYear;
    }

    public void setViewedYear(Long viewedYear) {
        this.viewedYear = viewedYear;
    }
//        return linkedLastAirDate;
//    }
//
//    public void setLinkedLastAirDate(String linkedLastAirDate) {
//        this.linkedLastAirDate = linkedLastAirDate;
//    }

    public Long getLastConnectedTime() {
        return lastConnectedTime;
    }

    public void setLastConnectedTime(Long lastConnectedTime) {
        this.lastConnectedTime = lastConnectedTime;
    }

    public Long getPublishLastModifyTime() {
        return publishLastModifyTime;
    }

    public void setPublishLastModifyTime(Long publishLastModifyTime) {
        this.publishLastModifyTime = publishLastModifyTime;
    }

    public Set<String> getCloudsAudioLanguage() {
        return cloudsAudioLanguage;
    }

    public void setCloudsAudioLanguage(Set<String> cloudsAudioLanguage) {
        this.cloudsAudioLanguage = cloudsAudioLanguage;
    }

    public Set<String> getSubtitles() {
        return subtitles;
    }

    public void setSubtitles(Set<String> subtitles) {
        this.subtitles = subtitles;
    }

    public Set<MediaSubtitleInfo> getSubtitleInfos() {
        return subtitleInfos;
    }

    public void setSubtitleInfos(Set<MediaSubtitleInfo> subtitleInfos) {
        this.subtitleInfos = subtitleInfos;
    }

    public LinkedHashSet<Long> getCountries() {
        return countries;
    }

    public void setCountries(LinkedHashSet<Long> countries) {
        this.countries = countries;
    }

    public List<MediaCertification> getCertifications() {
        return certifications;
    }

    public void setCertifications(List<MediaCertification> certifications) {
        this.certifications = certifications;
    }

    public int getLatestSeason() {
        return latestSeason;
    }

    public void setLatestSeason(int latestSeason) {
        this.latestSeason = latestSeason;
    }

    public int getLatestEpisode() {
        return latestEpisode;
    }

    public void setLatestEpisode(int latestEpisode) {
        this.latestEpisode = latestEpisode;
    }

    public int getOnTheAirAllLatestSeason() {
        return onTheAirAllLatestSeason;
    }

    public void setOnTheAirAllLatestSeason(int onTheAirAllLatestSeason) {
        this.onTheAirAllLatestSeason = onTheAirAllLatestSeason;
    }

    public int getOnTheAirAllLatestEpisode() {
        return onTheAirAllLatestEpisode;
    }

    public void setOnTheAirAllLatestEpisode(int onTheAirAllLatestEpisode) {
        this.onTheAirAllLatestEpisode = onTheAirAllLatestEpisode;
    }

    public String getLinkedLastAirDate() {
        return linkedLastAirDate;
    }

    public void setLinkedLastAirDate(String linkedLastAirDate) {
        this.linkedLastAirDate = linkedLastAirDate;
    }

    public String getOnTheAirAllLastAirDate() {
        return onTheAirAllLastAirDate;
    }

    public void setOnTheAirAllLastAirDate(String onTheAirAllLastAirDate) {
        this.onTheAirAllLastAirDate = onTheAirAllLastAirDate;
    }

    public Double getPopularity() {
        return popularity;
    }

    public void setPopularity(Double popularity) {
        this.popularity = popularity;
    }
}
