package com.valor.vod.meta.cache.model.playlist;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * 播放列表国际化类
 *
 * @author Tom Tang
 * @date 2021/7/13
 * @since 3.0.0
 */
@Getter
@ToString
@NoArgsConstructor(staticName = "create")
public class PlaylistI18n {

    private String language;

    private String title;

    private String poster;

    private String backdrop;

    private String backgroundImage;

    private String icoNormal;

    private String icoFocus;

    public PlaylistI18n setLanguage(String language) {
        this.language = language;
        return this;
    }

    public PlaylistI18n setTitle(String title) {
        this.title = title;
        return this;
    }

    public PlaylistI18n setPoster(String poster) {
        this.poster = poster;
        return this;
    }

    public PlaylistI18n setBackdrop(String backdrop) {
        this.backdrop = backdrop;
        return this;
    }

    public PlaylistI18n setBackgroundImage(String backgroundImage) {
        this.backgroundImage = backgroundImage;
        return this;
    }

    public PlaylistI18n setIcoNormal(String icoNormal) {
        this.icoNormal = icoNormal;
        return this;
    }

    public PlaylistI18n setIcoFocus(String icoFocus) {
        this.icoFocus = icoFocus;
        return this;
    }
}
