package com.valor.vod.meta.cache.service.common;

import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.StatusException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Service
public class SyncMediaService {

    @Autowired
    private RedisCache redisCache;

    public <T> void setObjects(String prefix, Map<Long, T> map) {
        Map<String, T> pMap = new HashMap<>();
        for (Map.Entry<Long, T> e : map.entrySet()) {
            String key = prefix + e.getKey();
            pMap.put(key, e.getValue());
        }
        redisCache.pipSetEx(pMap, 0);

    }

    public void delObjects(String prefix, Set<Long> vmsIdSet) {

        Set<String> keySet = new HashSet<>();
        for (Long key : vmsIdSet) {
            keySet.add(prefix + key);
        }
        redisCache.del(keySet.toArray(new String[0]));
    }

    public <T> T getObject(String prefix, Long vmsId) {
        return redisCache.get(prefix + vmsId);
    }


}
