package com.valor.vod.meta.cache.service.query;

import com.valor.vod.es.api.model.service.media.MediaImage;
import com.valor.vod.meta.cache.service.common.QueryMediaService;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import common.base.tools.stat.TimeStatisticsTools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.*;

@Service
public class QueryMediaImageService {
    @Autowired
    RedisCache redisCache;

    QueryMediaService<List<MediaImage>> queryMediaService;

    @PostConstruct
    public void init() {
        queryMediaService = new QueryMediaService<>(redisCache);
    }

    //artworkCache.getArtworks(id, language, isMaster, pageStart, pageSize)
    public Map<Long, List<MediaImage>> getMediaImageByVmsIds(Set<Long> idSet) {
        long beginTime = System.currentTimeMillis();
        Map<Long, List<MediaImage>> result = queryMediaService.getObjectByVmsIds(RedisPrefix.MediaImage, idSet);
        TimeStatisticsTools.addTime(String.format("REDIS-getMediaImageByVmsIds"), 1, System.currentTimeMillis() - beginTime);
        return result;
    }

    public List<MediaImage> getMediaImageByVmsId(Long id) {
        Set<Long> idSet = new HashSet<>();
        idSet.add(id);
        Map<Long, List<MediaImage>> map = getMediaImageByVmsIds(idSet);
        return map.getOrDefault(id, new ArrayList<>());
    }


}
