package com.valor.vod.meta.cache.service.query;

import com.valor.vod.api.common.SetTool;
import com.valor.vod.es.api.model.service.media.MediaSynopsis;
import com.valor.vod.meta.cache.service.common.QueryMediaService;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import common.base.tools.stat.TimeStatisticsTools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Service
public class QueryMediaSynopsisService {
    @Autowired
    RedisCache redisCache;

    QueryMediaService<List<MediaSynopsis>> queryMediaService;

    @PostConstruct
    public void init() {
        queryMediaService = new QueryMediaService<>(redisCache);
    }

    public Map<Long, List<MediaSynopsis>> getMediaSynopsisByVmsIds(Set<Long> idSet) {
        long beginTime = System.currentTimeMillis();
        Map<Long, List<MediaSynopsis>> result = queryMediaService.getObjectByVmsIds(RedisPrefix.MediaSynopsis, idSet);
        TimeStatisticsTools.addTime(String.format("REDIS-getMediaSynopsisByVmsIds"), 1, System.currentTimeMillis() - beginTime);
        return result;

    }

    public List<MediaSynopsis> getMediaSynopsisByVmsIds(Long id) {
        Map<Long, List<MediaSynopsis>> map = getMediaSynopsisByVmsIds(SetTool.asHashSet(id));
        return map.getOrDefault(id, new ArrayList<>());

    }


}
