package com.valor.vod.meta.cache.service.query;

import com.valor.vod.es.api.client.ESConstants;
import com.valor.vod.es.api.model.service.playlist.PlaylistNodeIndex;
import com.valor.vod.es.api.model.service.search.ESOrder;
import com.valor.vod.es.api.model.service.search.ESSearchParameter;
import com.valor.vod.es.api.model.service.search.ESTermFilterBuilder;
import com.valor.vod.meta.cache.model.constants.ESValueConstants;
import com.valor.vod.meta.cache.util.EsCache;
import common.config.tools.config.ConfigTools3;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

/**
 * @author Damon.Gao
 * @date 2022/9/8 17:51
 */
@Service
public class QueryPlaylistNodeService {
    @Autowired
    private EsCache esCache;

    public List<PlaylistNodeIndex> getPlaylistNodeIndexByParentPlaylistId(Long rootNodeId, Long parentPlaylistId, boolean queryOnTheAirLinked) {
        ESSearchParameter parameter = ESSearchParameter.builder().index(getPlaylistNodeIndexName())
                .type(ESConstants.TYPE_PLAYLIST_NODE).size(10000);
        parameter.add(ESOrder.asc("sortNo"));
        parameter.add(ESTermFilterBuilder.builder("parentPlaylistId").setValue(parentPlaylistId));
        parameter.add(ESTermFilterBuilder.builder("rootNodeId").setValue(rootNodeId));
        if (queryOnTheAirLinked) {
            parameter.add(ESTermFilterBuilder.builder("type").setValue(ESValueConstants.PLAYLIST_NODE_TYPE_LINEKD));
        }
        Set<PlaylistNodeIndex> indexes = esCache.searchWithScroll(parameter);
        return new ArrayList<>(indexes);
    }

    public List<PlaylistNodeIndex> getPlaylistNodeIndexByParentPlaylistId(Long rootNodeId,
                                                                          Long parentPlaylistId, boolean queryOnTheAirLinked, int from, int size) {
        ESSearchParameter parameter = ESSearchParameter.builder().index(getPlaylistNodeIndexName())
                .type(ESConstants.TYPE_PLAYLIST_NODE).from(from).size(size);
        parameter.add(ESOrder.asc("sortNo"));
        parameter.add(ESTermFilterBuilder.builder("parentPlaylistId").setValue(parentPlaylistId));
        parameter.add(ESTermFilterBuilder.builder("rootNodeId").setValue(rootNodeId));
        if (queryOnTheAirLinked) {
            parameter.add(ESTermFilterBuilder.builder("type").setValue(ESValueConstants.PLAYLIST_NODE_TYPE_LINEKD));
        }
        Set<PlaylistNodeIndex> indexes = esCache.search(parameter);
        return new ArrayList<>(indexes);
    }

    public int countPlaylistNodes(Long rootNodeId, Long parentPlaylistId, boolean queryOnTheAirLinked) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.size(0);
        BoolQueryBuilder bqb = QueryBuilders.boolQuery();
        searchSourceBuilder.query(bqb);

        BoolQueryBuilder filterQueryBuilder = QueryBuilders.boolQuery();
        filterQueryBuilder.must(QueryBuilders.termQuery("parentPlaylistId", parentPlaylistId));
        filterQueryBuilder.must(QueryBuilders.termQuery("rootNodeId", rootNodeId));
        if (queryOnTheAirLinked) {
            filterQueryBuilder.must(QueryBuilders.termQuery("type", ESValueConstants.PLAYLIST_NODE_TYPE_LINEKD));
        }
        bqb.filter(filterQueryBuilder);

        SearchResponse response = esCache.searchResponse(searchSourceBuilder, getPlaylistNodeIndexName(), ESConstants.TYPE_PLAYLIST_NODE);
        return (int) response.getHits().totalHits;
    }

    private String getPlaylistNodeIndexName() {
        return ConfigTools3.getString("index.playlistNode", ESConstants.INDEX_PLAYLIST_NODE);
    }
}
