package com.valor.vod.meta.cache.service.query;

import com.valor.vod.meta.cache.model.AccountEntity;
import com.valor.vod.meta.cache.model.UserCloud;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class QueryUserCloudService {
    @Autowired
    RedisCache redisCache;
//    getLinkedUserCloudAccountCidMap(accountId, isUserLocationIllegal)
//    linkedUserCloudAccountCache.getUserCloudAccountMapByIds(accountId, accountType, cids, isLocationIllegal)
//    linkedUserCloudAccountCache.getUserCloudAccounts(accountId,accountType)
//    getLinkedUserCloudCidMap(uid, isUserLocationIllegal)
//    linkedUserCloudCache.getUserCloudMapByIds(accountId, cids, isLocationIllegal)
//    linkedUserCloudCache.getUserClouds(uid)
//    getLinkedUserCloudDeviceCidMap(uid, isUserLocationIllegal)
//    linkedUserCloudDeviceCache.getUserCloudDeviceMapByIds(accountId, accountType, cids, isLocationIllegal)
//    linkedUserCloudDeviceCache.getUserCloudDevices(accountId,accountType)


    private String getKey(AccountEntity account) {
        return RedisPrefix.UserCloudAccountCid + account.getAccountId() + "_" + account.getAccountType();
    }

    public Map<AccountEntity, List<UserCloud>> getUserCloudByAccounts(List<AccountEntity> accounts) {
        Map<String, AccountEntity> keyAccountMap = new HashMap<>();
        Set<String> keySet = new HashSet<>();
        for (int i = 0; i < accounts.size(); i++) {
            AccountEntity account = accounts.get(i);
            String key = getKey(account);
            keyAccountMap.put(key, account);
            keySet.add(key);
        }
        Map<String, List<UserCloud>> userCloudMap = redisCache.mGet(keySet);
        Map<AccountEntity, List<UserCloud>> resultMap = new HashMap<>();
        for (Map.Entry<String, List<UserCloud>> e : userCloudMap.entrySet()) {
            if (!keyAccountMap.containsKey(e.getKey())) {
                continue;
            }
            AccountEntity account = keyAccountMap.get(e.getKey());
            resultMap.put(account, e.getValue());
        }
        return resultMap;
    }


}
