package com.valor.vod.meta.cache.service.query;

import com.valor.vod.es.api.model.service.cloud.MediaCloud;
import com.valor.vod.es.api.model.service.media.MediaDetail;
import com.valor.vod.es.api.model.service.media.MediaImage;
import com.valor.vod.es.api.model.service.person.Person;
import com.valor.vod.es.api.model.service.search.ESSearchParameter;
import com.valor.vod.meta.cache.util.EsCache;
import com.valor.vod.meta.cache.util.RedisCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class TestQueryService {
    @Autowired
    RedisCache redisCache;
    @Autowired
    EsCache esCache;

    //for test
    public Map<Long, MediaDetail> getMediaDetailForTest(ESSearchParameter parameter) {
        Set<MediaDetail> indexes = esCache.search(parameter);
        Map<Long, MediaDetail> map = new HashMap<>();
        for (MediaDetail mediaDetail : indexes) {
            map.put(mediaDetail.getId(), mediaDetail);
        }
        return map;
    }


    //for test
    public Map<String, MediaCloud> getMediaCloudForTest(ESSearchParameter parameter) {
        Set<MediaCloud> indexes = esCache.search(parameter);
        Map<String, MediaCloud> map = new HashMap<>();
        for (MediaCloud mediaDetail : indexes) {
            map.put(mediaDetail.getDocumentId(), mediaDetail);
        }
        return map;
    }


    //for test
    public Map<Long, Person> getPersonForTest(ESSearchParameter parameter) {
        Set<Person> indexes = esCache.search(parameter);
        Map<Long, Person> map = new HashMap<>();
        for (Person p : indexes) {
            map.put(p.getId(), p);
        }
        return map;
    }

    //for test
    public Map<Long, List<MediaImage>> getImageForTest(ESSearchParameter parameter) {
        Set<MediaImage> indexes = esCache.search(parameter);
        Map<Long, List<MediaImage>> map = new HashMap<>();
        List<MediaImage> images = new ArrayList<>();
        Long id = 0L;
        for (MediaImage p : indexes) {
            id = p.getId();
            images.add(p);
        }
        map.put(id, images);
        return map;
    }


}
