package com.valor.vod.meta.cache.util;

import com.valor.vod.meta.cache.constant.MetaCacheConstants;
import com.valor.vod.meta.cache.constant.MetaRedisKey;
import com.valor.vod.meta.cache.model.playlist.PlaylistNodeVersion;

import static com.valor.vod.meta.cache.constant.MetaCacheConstants.ROOT_NODE_VERSION;

/**
 * @author Bruce Wu
 * @since 2022-10-07
 */
public final class MetaCacheUtil {

    public static String getPlnPrefix() {
        PlaylistNodeVersion ver =
                (PlaylistNodeVersion) MetaCacheContext.getContext().get(ROOT_NODE_VERSION);
        return getPlnPrefix(ver);
    }

    public static String getPlnPrefix(PlaylistNodeVersion ver) {
        if (ver == null) {
            return null;
        }
        // pnv-1000013-1665304144000:
        return "pnv-" + ver.getPlaylistNodeId() + "-" + ver.getVersion() + ":";
    }

    public static boolean isOldPLKey() {
        return getPlnPrefix() == null;
    }

    public static boolean isPLDelete() {
        Object o = MetaCacheContext.getContext().get(MetaCacheConstants.ROOT_NODE_DELETE);
        if (o == null) {
            return false;
        }
        String os = o.toString();
        return "true".equalsIgnoreCase(os) || "1".equals(os) || "y".equalsIgnoreCase(os);
    }

    /**
     * 拼接播放列表相关的缓存KEY，带版本号的
     *
     * @param key
     * @param params
     * @return
     */
    public static String splicePLKeyStr(MetaRedisKey key, Object... params) {
        PlaylistNodeVersion pnv =
                (PlaylistNodeVersion) MetaCacheContext.getContext().get(ROOT_NODE_VERSION);
        return splicePLKeyStr(key, pnv, params);
    }

    /**
     * 拼接播放列表相关的缓存KEY，带版本号的
     *
     * @param key KEY
     * @param pnv 指定的版本号信息
     * @param params 参数
     * @return
     */
    public static String splicePLKeyStr(
            MetaRedisKey key, PlaylistNodeVersion pnv, Object... params) {
        String prefix = getPlnPrefix(pnv);
        String val = key.key(params);
        if (prefix == null) {
            return val;
        }
        return prefix + val;
    }

    /**
     * 拼接播放列表相关的缓存KEY，带版本号的
     *
     * @param key
     * @param params
     * @return
     */
    public static PLKey splicePLKey(MetaRedisKey key, Object... params) {
        String prefix = getPlnPrefix();
        String val = key.key(params);
        if (prefix == null) {
            return new PLKey(true, val);
        }
        return new PLKey(false, prefix + val);
    }

    public static class PLKey {
        boolean old;
        String key;

        public PLKey(boolean old, String key) {
            this.old = old;
            this.key = key;
        }

        public boolean isOld() {
            return old;
        }

        public String getKey() {
            return key;
        }
    }
}
