package com.valor.vod.meta.cache.util;

import com.valor.vod.api.model.common.response.ResponseStatus;
import com.valor.vod.api.model.constant.response.HttpCode2;


public class StatusException extends Exception {
    private int retCode = 0;     //返回码
    private int errCode = 0;     //错误码
    private String info = "ok";  //错误消息


    public static StatusException create(Exception ex) {
        StatusException e = new StatusException();
        e.setErrCode(HttpCode2.ERR_SYS_EXCEPTION);
        e.setRetCode(HttpCode2.RET_SYS_EXCEPTION);
        e.setInfo(ex.getMessage());
        return e;
    }


    public ResponseStatus toResponseStatus() {
        ResponseStatus statusResp = new ResponseStatus();
        statusResp.setErrCode(errCode);
        statusResp.setRetCode(retCode);
        statusResp.setMessage(info);
        return statusResp;
    }


    public int getRetCode() {
        return retCode;
    }

    public void setRetCode(int retCode) {
        this.retCode = retCode;
    }

    public int getErrCode() {
        return errCode;
    }

    public void setErrCode(int errCode) {
        this.errCode = errCode;
    }

    public String getInfo() {
        return info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

}
