/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.db;

import com.valor.vod.meta.model.database.dao.MetaDao;
import common.base.tools.type.CollectionUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.query.NativeQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional(value="metaTransactionManager")
public class CacheDao
extends MetaDao {
    private static final Logger logger = LoggerFactory.getLogger(CacheDao.class);

    public Map<Long, Set<Long>> queryVideoIdsByCids(Set<Long> cidSet) {
        HashMap<Long, Set<Long>> cidMap = new HashMap<Long, Set<Long>>();
        if (CollectionUtils.isNullOrEmpty(cidSet)) {
            return cidMap;
        }
        StringBuilder inSql = new StringBuilder();
        int i = 0;
        for (Long cid : cidSet) {
            if (i != 0) {
                inSql.append(",");
            }
            inSql.append(cid);
            ++i;
        }
        StringBuilder sqlSb = new StringBuilder();
        sqlSb.append("select cid,video_id from linked_cloud");
        sqlSb.append(" where cid in ( ");
        sqlSb.append((CharSequence)inSql);
        sqlSb.append(" )");
        NativeQuery sqlQuery = this.currentSession().createSQLQuery(sqlSb.toString());
        for (Object[] o : sqlQuery.list()) {
            Long cid = Long.parseLong(o[0].toString());
            Long videoId = Long.parseLong(o[1].toString());
            Set<Long> videoIdSet = null;
            if (cidMap.containsKey(cid)) {
                videoIdSet = (Set)cidMap.get(cid);
            } else {
                videoIdSet = new HashSet();
                cidMap.put(cid, videoIdSet);
            }
            videoIdSet.add(videoId);
        }
        return cidMap;
    }
}

