/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.common;

import com.valor.vod.common.cache.redis.ProtobufRedisTemplate;
import com.valor.vod.common.database.tool.access.SqlScalars;
import com.valor.vod.common.web.tools.VodException;
import com.valor.vod.meta.cache.constant.MetaRedisKey;
import com.valor.vod.meta.cache.model.playlist.PlaylistNodeVersion;
import com.valor.vod.meta.cache.util.MetaCacheContext;
import com.valor.vod.meta.cache.util.MetaCacheUtil;
import com.valor.vod.meta.model.database.constants.playlist.EPlaylistListType;
import com.valor.vod.meta.model.database.constants.playlist.EPlaylistNodeVersionAct;
import com.valor.vod.meta.model.database.constants.playlist.EPlaylistRefListSubType;
import com.valor.vod.meta.model.database.dao.PlaylistVersionDao;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistNodeDDO;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistNodeVersionDDO;
import com.valor.vod.meta.model.database.tools.playlist.PlaylistIdTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class PlaylistVersionService {
    private static final Logger log = LoggerFactory.getLogger(PlaylistVersionService.class);
    private static final int MAX_SEARCH_DEPTH = 20;
    private PlaylistVersionDao playlistVersionDao;
    private ProtobufRedisTemplate protobufRedisTemplate;

    @Autowired
    public void setPlaylistNodeVersionDao(PlaylistVersionDao playlistVersionDao) {
        this.playlistVersionDao = playlistVersionDao;
    }

    @Autowired
    public void setProtobufRedisTemplate(ProtobufRedisTemplate protobufRedisTemplate) {
        this.protobufRedisTemplate = protobufRedisTemplate;
    }

    public void deleteCache(Long rootNodeId) {
        String key = MetaRedisKey.KEY_PLAYLIST_NODE_VERSION.key(rootNodeId);
        this.protobufRedisTemplate.delete((Object)key);
    }

    public void savePlvKey(String key) {
        if (key == null || key.isEmpty()) {
            return;
        }
        String plvKeysKey = MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLV_KEYS, new Object[0]);
        this.protobufRedisTemplate.opsForSet().add((Object)plvKeysKey, new Object[]{key});
    }

    public void savePlvKey(Collection<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        String plvKeysKey = MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLV_KEYS, new Object[0]);
        this.protobufRedisTemplate.opsForSet().add((Object)plvKeysKey, keys.toArray(new Object[0]));
    }

    public PlaylistNodeVersion fetchForQuery(Long rootNodeId) {
        String key = MetaRedisKey.KEY_PLAYLIST_NODE_VERSION.key(rootNodeId);
        PlaylistNodeVersion version = (PlaylistNodeVersion)this.protobufRedisTemplate.opsForValue().get((Object)key);
        if (version == null) {
            PlaylistNodeVersionDDO ddo = this.playlistVersionDao.getLatestValid(rootNodeId);
            if (ddo == null) {
                throw new VodException(HttpStatus.NOT_FOUND, 4, 306, "[meta-playlist_version] not exist.");
            }
            version = new PlaylistNodeVersion();
            BeanUtils.copyProperties((Object)ddo, (Object)version);
            this.protobufRedisTemplate.opsForValue().set((Object)key, (Object)version);
        }
        if (version.getAct().byteValue() == EPlaylistNodeVersionAct.DELETE.ordinal()) {
            throw new VodException(HttpStatus.NOT_FOUND, 4, 307, "[meta-playlist_node] root is deleted.");
        }
        MetaCacheContext.getContext().set("rootNodeVersion", version);
        return version;
    }

    public List<Long> searchTreeRootNodeIds(Long playlistId) {
        HashSet<Long> result = new HashSet<Long>();
        this.recursiveFindRootNode(playlistId, result, 1);
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        return this.playlistVersionDao.getTreeRootNodeIds(new ArrayList<Long>(result));
    }

    public void syncTaskForPids(List<Long> pids, Runnable task) {
        HashSet<Long> rootNodeIds = new HashSet<Long>();
        pids.forEach(e -> rootNodeIds.addAll(this.searchTreeRootNodeIds((Long)e)));
        this.syncTaskForNodes(rootNodeIds, task);
    }

    public void syncTaskForNodes(Collection<Long> rootNodeIds, Runnable task) {
        for (Long nodeId : rootNodeIds) {
            try {
                this.fetchForQuery(nodeId);
                MetaCacheContext.getContext().set("rootNodeDelete", true);
                task.run();
            }
            catch (VodException e) {
                log.warn("Sync root fail. nodeId:{}, errCode:{}", new Object[]{nodeId, e.getErrCode(), e});
            }
            catch (Exception e) {
                log.warn("Sync root fail seriously. nodeId -> {}", (Object)nodeId, (Object)e);
            }
        }
    }

    private void recursiveFindRootNode(Long playlistId, Set<Long> result, int depth) {
        if (playlistId == null) {
            return;
        }
        if (depth > 20) {
            log.warn("Number of recursive calls is too large for find root node");
            return;
        }
        List nodes = this.playlistVersionDao.getParentNodes(playlistId.longValue());
        for (PlaylistNodeDDO node : nodes) {
            if (node.getParentPlaylistId() == null || node.getParentPlaylistId() <= 0L) {
                result.add(node.getId());
                continue;
            }
            this.recursiveFindRootNode(node.getParentPlaylistId(), result, depth + 1);
        }
        Consumer<List> consumer = ids -> {
            for (Object e : ids) {
                Long id = Long.valueOf(e.toString());
                if (Objects.equals(id, playlistId)) continue;
                this.recursiveFindRootNode(id, result, depth + 1);
            }
        };
        SqlScalars sqlScalars = new SqlScalars("select id from playlist where ref_id =:refId");
        sqlScalars.addParameter("refId", (Object)playlistId);
        List refIds = this.playlistVersionDao.query(null, sqlScalars, false);
        consumer.accept(refIds);
        long onTheAirAllId = PlaylistIdTools.getId((String)"10000000", (EPlaylistRefListSubType)EPlaylistRefListSubType.ON_THE_AIR);
        long onTheAirLinkedId = PlaylistIdTools.getId((String)"10000000", (EPlaylistRefListSubType)EPlaylistRefListSubType.ON_THE_AIR_LINKED);
        if (Objects.equals(playlistId, onTheAirAllId) || Objects.equals(playlistId, onTheAirLinkedId)) {
            SqlScalars onTheAirQuery = new SqlScalars("select id from playlist where sub_type = :subType and list_type = :listType");
            onTheAirQuery.addParameter("subType", (Object)EPlaylistRefListSubType.ON_THE_AIR.name());
            onTheAirQuery.addParameter("listType", (Object)EPlaylistListType.REF_LIST.name());
            List onTheAirIds = this.playlistVersionDao.query(null, onTheAirQuery, false);
            consumer.accept(onTheAirIds);
        }
    }
}

