/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.query;

import com.valor.vod.common.cache.redis.ProtobufRedisTemplate;
import com.valor.vod.meta.cache.constant.MetaRedisKey;
import com.valor.vod.meta.cache.model.playlist.NodeDisplay;
import com.valor.vod.meta.cache.model.playlist.Playlist;
import com.valor.vod.meta.cache.model.playlist.PlaylistNode;
import com.valor.vod.meta.cache.model.playlist.PlaylistTag;
import com.valor.vod.meta.cache.util.EsCache;
import com.valor.vod.meta.cache.util.MetaCacheUtil;
import com.valor.vod.meta.model.database.constants.playlist.ESystemListSubType2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlaylistCacheQueryService {
    private ProtobufRedisTemplate protobufRedisTemplate;
    private EsCache esCache;

    public Optional<Playlist> getPlaylist(long playlistId) {
        String playlistKey = MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLAYLIST, playlistId);
        Playlist playlist = (Playlist)this.protobufRedisTemplate.opsForValue().get((Object)playlistKey);
        return Optional.ofNullable(playlist);
    }

    public Optional<Long> getPlaylistIdByName(String name) {
        String key = MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_NAME_TO_PLAYLIST_ID, name);
        Long id = (Long)this.protobufRedisTemplate.opsForValue().get((Object)key);
        return Optional.ofNullable(id);
    }

    public List<Playlist> getPlaylists(Collection<Long> playlistIds) {
        List playlistKeys = playlistIds.stream().map(playlistId -> MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLAYLIST, playlistId)).collect(Collectors.toList());
        List list = this.protobufRedisTemplate.opsForValue().multiGet(playlistKeys);
        return Optional.ofNullable(list).orElse(Collections.emptyList()).stream().filter(Objects::nonNull).map(e -> (Playlist)e).collect(Collectors.toList());
    }

    public Optional<Long> getNodeIdByPlaylistId(long playlistId) {
        String key = MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLAYLIST_ID_TO_NODE_ID, playlistId);
        Long id = (Long)this.protobufRedisTemplate.opsForValue().get((Object)key);
        return Optional.ofNullable(id);
    }

    public Optional<PlaylistNode> getPlaylistNode(long nodeId) {
        String key = MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLAYLIST_NODE, nodeId);
        PlaylistNode playlistNode = (PlaylistNode)this.protobufRedisTemplate.opsForValue().get((Object)key);
        return Optional.ofNullable(playlistNode);
    }

    public Optional<NodeDisplay> getNodeDisplay(long nodeId, long productId) {
        String key = MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_NODE_DISPLAY, nodeId);
        NodeDisplay nd = (NodeDisplay)this.protobufRedisTemplate.opsForHash().get((Object)key, (Object)Long.toString(productId));
        return Optional.ofNullable(nd);
    }

    public List<PlaylistTag> getPlaylistTags(long nodeId, long productId) {
        String key = MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLAYLIST_TAGS, nodeId);
        List list = (List)this.protobufRedisTemplate.opsForHash().get((Object)key, (Object)Long.toString(productId));
        return Optional.ofNullable(list).orElse(Collections.emptyList());
    }

    public List<PlaylistNode> getSysGenreNodesOrTagNodes(Long rootNodeId, ESystemListSubType2 type, Collection<String> genreIdsOrTagIds) {
        String key = MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_SYSTEM_LIST, rootNodeId, type.name());
        return this.protobufRedisTemplate.opsForHash().multiGet((Object)key, new ArrayList<String>(genreIdsOrTagIds)).stream().filter(Objects::nonNull).map(e -> (PlaylistNode)e).collect(Collectors.toList());
    }

    public Optional<PlaylistNode> getSysPlaylistNode(Long rootNodeId, ESystemListSubType2 type) {
        String key = MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_SYSTEM_LIST, rootNodeId, type.name());
        PlaylistNode node = (PlaylistNode)this.protobufRedisTemplate.opsForValue().get((Object)key);
        return Optional.ofNullable(node);
    }

    @Autowired
    public void setProtobufRedisTemplate(ProtobufRedisTemplate protobufRedisTemplate) {
        this.protobufRedisTemplate = protobufRedisTemplate;
    }

    @Autowired
    public void setEsCache(EsCache esCache) {
        this.esCache = esCache;
    }
}

