/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.query;

import com.valor.vod.api.common.SetTool;
import com.valor.vod.meta.cache.model.CloudAcct;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryCloudAcctService {
    @Autowired
    RedisCache redisCache;

    private Set<String> getKeySet(Set<Long> idSet) {
        HashSet<String> keySet = new HashSet<String>();
        for (Long id : idSet) {
            String key = RedisPrefix.CloudAcct + id;
            keySet.add(key);
        }
        return keySet;
    }

    public Map<Long, CloudAcct> getCloudAcctByCids(Set<Long> cidSet) {
        Set<String> keySet = this.getKeySet(cidSet);
        Map detailMap = this.redisCache.mGet(keySet);
        HashMap<Long, CloudAcct> resultMap = new HashMap<Long, CloudAcct>();
        for (Map.Entry e : detailMap.entrySet()) {
            CloudAcct md = (CloudAcct)e.getValue();
            resultMap.put(md.getCid(), md);
        }
        return resultMap;
    }

    public CloudAcct getCloudAcctByCids(Long cid) {
        Map<Long, CloudAcct> map = this.getCloudAcctByCids(SetTool.asHashSet((Object[])new Long[]{cid}));
        return map.getOrDefault(cid, null);
    }

    public Long getCidBySiteAndAcct(String site, String acct) {
        String key = RedisPrefix.CloudAcctAcctSiteCid + site + "_" + acct;
        Long cid = (Long)this.redisCache.get(key);
        return cid;
    }
}

