/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.query;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.valor.vod.api.common.SetTool;
import com.valor.vod.api.model.constant.EVideoType;
import com.valor.vod.common.tools.stat.BeanMethodStatistics;
import com.valor.vod.common.tools.type.CollectionUtils;
import com.valor.vod.es.api.model.YmlIndex;
import com.valor.vod.es.api.model.service.media.MediaDetail;
import com.valor.vod.es.api.model.service.media.MediaSearchIndex;
import com.valor.vod.es.api.model.service.search.ESOrder;
import com.valor.vod.es.api.model.service.search.ESSearchParameter;
import com.valor.vod.es.api.model.service.search.ESTermFilterBuilder;
import com.valor.vod.es.api.model.service.search.IESFilterBuilder;
import com.valor.vod.meta.cache.model.MediaListSummary;
import com.valor.vod.meta.cache.util.EsCache;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import common.base.tools.stat.TimeStatisticsTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedLongTerms;
import org.elasticsearch.search.aggregations.metrics.cardinality.ParsedCardinality;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryMediaDetailService {
    private static final Logger log = LoggerFactory.getLogger(QueryMediaDetailService.class);
    @Autowired
    RedisCache redisCache;
    @Autowired
    EsCache esCache;

    private Set<String> getDetailKeySet(Set<Long> idSet) {
        HashSet<String> keySet = new HashSet<String>();
        for (Long id : idSet) {
            String key = RedisPrefix.MediaDetail + id;
            keySet.add(key);
        }
        return keySet;
    }

    private Set<String> getSummaryKeySet(Set<Long> idSet) {
        HashSet<String> keySet = new HashSet<String>();
        for (Long id : idSet) {
            String key = RedisPrefix.MediaDetailSummary + id;
            keySet.add(key);
        }
        return keySet;
    }

    private Set<String> getMetaIdKeySet(Set<String> metaIdSet) {
        HashSet<String> keySet = new HashSet<String>();
        for (String id : metaIdSet) {
            String key = RedisPrefix.MediaDetailMetaIdId + id;
            keySet.add(key);
        }
        return keySet;
    }

    private Set<String> getPpIdKeySet(Set<String> ppIdSet) {
        HashSet<String> keySet = new HashSet<String>();
        for (String id : ppIdSet) {
            String key = RedisPrefix.MediaDetailPpIdId + id;
            keySet.add(key);
        }
        return keySet;
    }

    public Map<Long, MediaDetail> getMediaDetailByVmsIds(Set<Long> idSet) {
        Set<String> keySet = this.getDetailKeySet(idSet);
        Map detailMap = this.redisCache.mGet(keySet);
        HashMap<Long, MediaDetail> resultMap = new HashMap<Long, MediaDetail>();
        for (Map.Entry e : detailMap.entrySet()) {
            MediaDetail md = (MediaDetail)e.getValue();
            resultMap.put(md.getId(), md);
        }
        return resultMap;
    }

    public MediaDetail getMediaDetailByVmsId(Long id) {
        Map<Long, MediaDetail> map = this.getMediaDetailByVmsIds(SetTool.asHashSet((Object[])new Long[]{id}));
        return map.getOrDefault(id, null);
    }

    public Map<Long, MediaDetail> getMediaDetailByIndexes(List<MediaSearchIndex> searchIndices) {
        HashSet<Long> idSet = new HashSet<Long>();
        for (int i = 0; i < searchIndices.size(); ++i) {
            MediaSearchIndex searchIndex = searchIndices.get(i);
            idSet.add(searchIndex.getId());
        }
        Map<Long, MediaDetail> detailMap = this.getMediaDetailByVmsIds(idSet);
        return detailMap;
    }

    public List<String> getMediaIdsBySeriesIdAndSeasonIdAndEpisodeOrder(long seriesId, long seasonId, String episodeOrder) {
        ESSearchParameter parameter = ESSearchParameter.builder().index("media_search_index").type("media_search_index").size(10000);
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"seriesId").setValue((Object)seriesId));
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"seasonId").setValue((Object)seasonId));
        if (Strings.isNullOrEmpty((String)episodeOrder) || "desc".equalsIgnoreCase(episodeOrder)) {
            parameter.add(ESOrder.desc((String)"episode"));
        } else {
            parameter.add(ESOrder.asc((String)"episode"));
        }
        List<String> indexes = this.esCache.searchId(parameter);
        return indexes;
    }

    public List<String> getMediaIdsBySeriesIdAndMediaType(long seriesId, int mediaType) {
        ESSearchParameter parameter = ESSearchParameter.builder().index("media_search_index").type("media_search_index").size(10000);
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"seriesId").setValue((Object)seriesId));
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"mediaType").setValue((Object)mediaType));
        List<String> indexes = this.esCache.searchId(parameter);
        return indexes;
    }

    public MediaListSummary getMediaSummaryByVmsId(Long id) {
        Map<Long, MediaListSummary> map = this.getMediaSummaryByVmsIds(SetTool.asHashSet((Object[])new Long[]{id}));
        return map.getOrDefault(id, null);
    }

    @BeanMethodStatistics
    public Map<Long, MediaListSummary> getMediaSummaryByVmsIds(Set<Long> idSet) {
        long beginTime = System.currentTimeMillis();
        Set<String> keySet = this.getSummaryKeySet(idSet);
        Map detailMap = this.redisCache.mGet(keySet);
        HashMap<Long, MediaListSummary> resultMap = new HashMap<Long, MediaListSummary>();
        for (Map.Entry e : detailMap.entrySet()) {
            MediaListSummary ms = (MediaListSummary)e.getValue();
            resultMap.put(ms.getId(), ms);
        }
        TimeStatisticsTools.addTime((String)String.format("REDIS-getMediaSummaryByVmsIds", new Object[0]), (int)1, (long)(System.currentTimeMillis() - beginTime));
        return resultMap;
    }

    public List<String> getMediaIds(ESSearchParameter parameter, int[] totalCount) {
        List<String> indexes = this.esCache.searchId(parameter, totalCount);
        return indexes;
    }

    public List<String> getMediaIds(ESSearchParameter parameter) {
        return this.esCache.searchId(parameter);
    }

    public List<String> getSecondAudioMediaIds(SearchSourceBuilder searchSourceBuilder, int[] totalCount) {
        if (searchSourceBuilder == null) {
            return new ArrayList<String>();
        }
        SearchResponse response = this.esCache.searchResponse(searchSourceBuilder, "second_audio_search_index", "second_audio_search_index");
        if (response == null) {
            return new ArrayList<String>();
        }
        Aggregations aggregations = response.getAggregations();
        Map aggregationMap = aggregations.getAsMap();
        ParsedCardinality totalCountAggr = (ParsedCardinality)aggregationMap.get("total_count");
        totalCount[0] = (int)totalCountAggr.getValue();
        ParsedLongTerms idsAggr = (ParsedLongTerms)aggregationMap.get("ids");
        List buckets = idsAggr.getBuckets();
        return buckets.stream().map(bucket -> bucket.getKey().toString()).collect(Collectors.toList());
    }

    public Map<String, Long> getVmsIdByMetaIds(Set<String> metaIdSet) {
        long beginTime = System.currentTimeMillis();
        Set<String> keySet = this.getMetaIdKeySet(metaIdSet);
        Map detailMap = this.redisCache.mGet(keySet);
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        for (Map.Entry e : detailMap.entrySet()) {
            String metaId = e.getKey().substring(RedisPrefix.MediaDetailMetaIdId.length());
            resultMap.put(metaId, (Long)e.getValue());
        }
        TimeStatisticsTools.addTime((String)String.format("REDIS-getVmsIdByMetaIds", new Object[0]), (int)1, (long)(System.currentTimeMillis() - beginTime));
        return resultMap;
    }

    public Map<String, Long> getVmsIdByPpIds(Set<String> ppIdSet) {
        long beginTime = System.currentTimeMillis();
        Set<String> keySet = this.getPpIdKeySet(ppIdSet);
        Map detailMap = this.redisCache.mGet(keySet);
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        for (Map.Entry e : detailMap.entrySet()) {
            String metaId = e.getKey().substring(RedisPrefix.MediaDetailPpIdId.length());
            resultMap.put(metaId, (Long)e.getValue());
        }
        TimeStatisticsTools.addTime((String)String.format("REDIS-getVmsIdByPpIds", new Object[0]), (int)1, (long)(System.currentTimeMillis() - beginTime));
        return resultMap;
    }

    public List<MediaListSummary> getConnectedEpisodeMediaListSummaryBySeriesId(long seriesId) {
        ESSearchParameter parameter = ESSearchParameter.builder().index("media_search_index").type("media_search_index").size(10000);
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"seriesId").setValue((Object)seriesId));
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"mediaType").setValue((Object)EVideoType.EPISODE.ordinal()));
        Set indexes = this.esCache.searchWithScroll(parameter);
        List validIndexes = indexes.stream().filter(mediaSearchIndex -> ObjectUtils.isNotEmpty((Object)mediaSearchIndex.getCloudsAudioLanguage())).collect(Collectors.toList());
        List batchList = Lists.partition(new ArrayList(validIndexes), (int)100);
        return batchList.stream().map(list -> {
            Set<Long> ids = list.stream().map(index -> index.getId()).collect(Collectors.toSet());
            Map<Long, MediaListSummary> result = this.getMediaSummaryByVmsIds(ids);
            return result.values();
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Long> getYMLByAccountId(Long id) {
        ESSearchParameter parameter = ESSearchParameter.builder().index("yml_index").type("yml_index").size(1).add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"uid").setValue((Object)id));
        Set indexes = this.esCache.search(parameter);
        if (CollectionUtils.isNullOrEmpty(indexes)) {
            return null;
        }
        return ((YmlIndex)new ArrayList(indexes).get(0)).getVmsIds();
    }

    public Pair<Integer, List<MediaSearchIndex>> queryByCondition(ESSearchParameter esSearchParameter) {
        int[] totalCount = new int[]{0};
        Set indexes = this.esCache.search(esSearchParameter, totalCount);
        return Pair.of((Object)totalCount[0], new ArrayList(indexes));
    }
}

