/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.query;

import com.valor.vod.api.common.SetTool;
import com.valor.vod.common.tools.stat.BeanMethodStatistics;
import com.valor.vod.es.api.model.service.person.Person;
import com.valor.vod.es.api.model.service.person.PersonSearchIndex;
import com.valor.vod.es.api.model.service.search.ESSearchParameter;
import com.valor.vod.meta.cache.util.EsCache;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import common.base.tools.stat.TimeStatisticsTools;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryMediaPersonService {
    @Autowired
    RedisCache redisCache;
    @Autowired
    EsCache esCache;

    private Set<String> getKeySet(Set<Long> idSet) {
        HashSet<String> keySet = new HashSet<String>();
        for (Long id : idSet) {
            String key = RedisPrefix.Person + id;
            keySet.add(key);
        }
        return keySet;
    }

    private Set<String> getMetaKeySet(Set<String> metaIdSet) {
        HashSet<String> keySet = new HashSet<String>();
        for (String id : metaIdSet) {
            String key = RedisPrefix.PersonMetaIdId + id;
            keySet.add(key);
        }
        return keySet;
    }

    @BeanMethodStatistics
    public Map<Long, Person> getMediaPersonByIds(Set<Long> idSet) {
        long beginTime = System.currentTimeMillis();
        Set<String> keySet = this.getKeySet(idSet);
        Map detailMap = this.redisCache.mGet(keySet);
        HashMap<Long, Person> resultMap = new HashMap<Long, Person>();
        for (Map.Entry e : detailMap.entrySet()) {
            Person md = (Person)e.getValue();
            resultMap.put(md.getId(), md);
        }
        TimeStatisticsTools.addTime((String)String.format("REDIS-getMediaPersonByIds", new Object[0]), (int)1, (long)(System.currentTimeMillis() - beginTime));
        return resultMap;
    }

    public Person getMediaPersonById(Long id) {
        Map<Long, Person> personMap = this.getMediaPersonByIds(SetTool.asHashSet((Object[])new Long[]{id}));
        return personMap.getOrDefault(id, null);
    }

    public Long getVmsIdByMetaIds(String metaId) {
        Map<String, Long> map = this.getVmsIdByMetaIds(SetTool.asHashSet((Object[])new String[]{metaId}));
        return map.getOrDefault(metaId, null);
    }

    public Map<String, Long> getVmsIdByMetaIds(Set<String> metaIdSet) {
        long beginTime = System.currentTimeMillis();
        Set<String> keySet = this.getMetaKeySet(metaIdSet);
        Map detailMap = this.redisCache.mGet(keySet);
        HashMap<String, Long> resultMap = new HashMap<String, Long>();
        for (Map.Entry e : detailMap.entrySet()) {
            Long vmsId = Long.parseLong(String.valueOf(e.getValue()));
            resultMap.put(e.getKey().substring(RedisPrefix.PersonMetaIdId.length()), vmsId);
        }
        TimeStatisticsTools.addTime((String)String.format("REDIS-getVmsIdByMetaIds", new Object[0]), (int)1, (long)(System.currentTimeMillis() - beginTime));
        return resultMap;
    }

    public List<String> getMediaPersonIds(ESSearchParameter parameter, int[] totalCount) {
        List<String> indexes = this.esCache.searchId(parameter, totalCount);
        return indexes;
    }

    public Map<Long, Person> getMediaPersonByIndexes(List<PersonSearchIndex> searchIndices) {
        HashSet<Long> idSet = new HashSet<Long>();
        for (int i = 0; i < searchIndices.size(); ++i) {
            PersonSearchIndex searchIndex = searchIndices.get(i);
            idSet.add(searchIndex.getId());
        }
        Map<Long, Person> detailMap = this.getMediaPersonByIds(idSet);
        return detailMap;
    }
}

