/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.query;

import com.valor.vod.es.api.model.service.playlist.PlaylistNodeIndex;
import com.valor.vod.es.api.model.service.search.ESOrder;
import com.valor.vod.es.api.model.service.search.ESSearchParameter;
import com.valor.vod.es.api.model.service.search.ESTermFilterBuilder;
import com.valor.vod.es.api.model.service.search.IESFilterBuilder;
import com.valor.vod.meta.cache.util.EsCache;
import common.config.tools.config.ConfigTools3;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryPlaylistNodeService {
    @Autowired
    private EsCache esCache;

    public List<PlaylistNodeIndex> getPlaylistNodeIndexByParentPlaylistId(Long rootNodeId, Long parentPlaylistId, boolean queryOnTheAirLinked) {
        ESSearchParameter parameter = ESSearchParameter.builder().index(this.getPlaylistNodeIndexName()).type("playlist_node").size(10000);
        parameter.add(ESOrder.asc((String)"sortNo"));
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"parentPlaylistId").setValue((Object)parentPlaylistId));
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"rootNodeId").setValue((Object)rootNodeId));
        if (queryOnTheAirLinked) {
            parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"type").setValue((Object)"lineked"));
        }
        Set indexes = this.esCache.searchWithScroll(parameter);
        return new ArrayList<PlaylistNodeIndex>(indexes);
    }

    public List<PlaylistNodeIndex> getPlaylistNodeIndexByParentPlaylistId(Long rootNodeId, Long parentPlaylistId, boolean queryOnTheAirLinked, int from, int size) {
        ESSearchParameter parameter = ESSearchParameter.builder().index(this.getPlaylistNodeIndexName()).type("playlist_node").from(from).size(size);
        parameter.add(ESOrder.asc((String)"sortNo"));
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"parentPlaylistId").setValue((Object)parentPlaylistId));
        parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"rootNodeId").setValue((Object)rootNodeId));
        if (queryOnTheAirLinked) {
            parameter.add((IESFilterBuilder)ESTermFilterBuilder.builder((String)"type").setValue((Object)"lineked"));
        }
        Set indexes = this.esCache.search(parameter);
        return new ArrayList<PlaylistNodeIndex>(indexes);
    }

    public int countPlaylistNodes(Long rootNodeId, Long parentPlaylistId, boolean queryOnTheAirLinked) {
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        searchSourceBuilder.size(0);
        BoolQueryBuilder bqb = QueryBuilders.boolQuery();
        searchSourceBuilder.query((QueryBuilder)bqb);
        BoolQueryBuilder filterQueryBuilder = QueryBuilders.boolQuery();
        filterQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"parentPlaylistId", (Object)parentPlaylistId));
        filterQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"rootNodeId", (Object)rootNodeId));
        if (queryOnTheAirLinked) {
            filterQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)"lineked"));
        }
        bqb.filter((QueryBuilder)filterQueryBuilder);
        SearchResponse response = this.esCache.searchResponse(searchSourceBuilder, this.getPlaylistNodeIndexName(), "playlist_node");
        return (int)response.getHits().totalHits;
    }

    private String getPlaylistNodeIndexName() {
        return ConfigTools3.getString((String)"index.playlistNode", (String)"playlist_node");
    }
}

