/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.query;

import com.valor.vod.meta.cache.model.AccountEntity;
import com.valor.vod.meta.cache.model.UserCloud;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryUserCloudService {
    @Autowired
    RedisCache redisCache;

    private String getKey(AccountEntity account) {
        return RedisPrefix.UserCloudAccountCid + account.getAccountId() + "_" + account.getAccountType();
    }

    public Map<AccountEntity, List<UserCloud>> getUserCloudByAccounts(List<AccountEntity> accounts) {
        HashMap<String, AccountEntity> keyAccountMap = new HashMap<String, AccountEntity>();
        HashSet<String> keySet = new HashSet<String>();
        for (int i = 0; i < accounts.size(); ++i) {
            AccountEntity account = accounts.get(i);
            String key = this.getKey(account);
            keyAccountMap.put(key, account);
            keySet.add(key);
        }
        Map userCloudMap = this.redisCache.mGet(keySet);
        HashMap<AccountEntity, List<UserCloud>> resultMap = new HashMap<AccountEntity, List<UserCloud>>();
        for (Map.Entry e : userCloudMap.entrySet()) {
            if (!keyAccountMap.containsKey(e.getKey())) continue;
            AccountEntity account = (AccountEntity)keyAccountMap.get(e.getKey());
            resultMap.put(account, (List<UserCloud>)e.getValue());
        }
        return resultMap;
    }
}

