/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.query;

import com.valor.vod.es.api.model.service.cloud.MediaCloud;
import com.valor.vod.es.api.model.service.media.MediaDetail;
import com.valor.vod.es.api.model.service.media.MediaImage;
import com.valor.vod.es.api.model.service.person.Person;
import com.valor.vod.es.api.model.service.search.ESSearchParameter;
import com.valor.vod.meta.cache.util.EsCache;
import com.valor.vod.meta.cache.util.RedisCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TestQueryService {
    @Autowired
    RedisCache redisCache;
    @Autowired
    EsCache esCache;

    public Map<Long, MediaDetail> getMediaDetailForTest(ESSearchParameter parameter) {
        Set indexes = this.esCache.search(parameter);
        HashMap<Long, MediaDetail> map = new HashMap<Long, MediaDetail>();
        for (MediaDetail mediaDetail : indexes) {
            map.put(mediaDetail.getId(), mediaDetail);
        }
        return map;
    }

    public Map<String, MediaCloud> getMediaCloudForTest(ESSearchParameter parameter) {
        Set indexes = this.esCache.search(parameter);
        HashMap<String, MediaCloud> map = new HashMap<String, MediaCloud>();
        for (MediaCloud mediaDetail : indexes) {
            map.put(mediaDetail.getDocumentId(), mediaDetail);
        }
        return map;
    }

    public Map<Long, Person> getPersonForTest(ESSearchParameter parameter) {
        Set indexes = this.esCache.search(parameter);
        HashMap<Long, Person> map = new HashMap<Long, Person>();
        for (Person p : indexes) {
            map.put(p.getId(), p);
        }
        return map;
    }

    public Map<Long, List<MediaImage>> getImageForTest(ESSearchParameter parameter) {
        Set indexes = this.esCache.search(parameter);
        HashMap<Long, List<MediaImage>> map = new HashMap<Long, List<MediaImage>>();
        ArrayList<MediaImage> images = new ArrayList<MediaImage>();
        Long id = 0L;
        for (MediaImage p : indexes) {
            id = p.getId();
            images.add(p);
        }
        map.put(id, images);
        return map;
    }
}

