/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.sync;

import com.valor.vod.api.model.constant.EArtworkType;
import com.valor.vod.common.tools.type.CollectionUtils;
import com.valor.vod.es.api.model.service.media.MediaDetail;
import com.valor.vod.es.api.model.service.media.MediaRelease;
import com.valor.vod.meta.cache.model.MediaPosterResp;
import com.valor.vod.meta.cache.service.common.SyncMediaService;
import com.valor.vod.meta.cache.util.RedisPrefix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SyncOtherService {
    @Autowired
    private SyncMediaService syncMediaService;

    public List<MediaPosterResp> getMasterPoster(Long vmsId) {
        List artworks = (List)this.syncMediaService.getObject(RedisPrefix.MediaImage, vmsId);
        if (CollectionUtils.isNullOrEmpty((Collection)artworks)) {
            return new ArrayList<MediaPosterResp>();
        }
        List<MediaPosterResp> result = artworks.stream().filter(artwork -> artwork.getMaster() == 1 && Objects.equals(artwork.getArtworkType(), EArtworkType.POSTER.name())).map(artwork -> {
            MediaPosterResp resp = new MediaPosterResp();
            resp.setLanguage(artwork.getLanguage());
            resp.setUrl(artwork.getUrl());
            return resp;
        }).collect(Collectors.toList());
        return result;
    }

    public List<MediaRelease> getMediaRelease(Long vmsId) {
        MediaDetail mediaDetail = (MediaDetail)this.syncMediaService.getObject(RedisPrefix.MediaDetail, vmsId);
        if (mediaDetail == null) {
            return new ArrayList<MediaRelease>();
        }
        return mediaDetail.getRelease();
    }
}

