/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.service.sync;

import com.valor.vod.common.cache.redis.ProtobufRedisTemplate;
import com.valor.vod.common.web.aop.annotation.ExceptionConverter;
import com.valor.vod.es.api.model.service.base.IDocument;
import com.valor.vod.es.api.model.service.playlist.PlaylistNodeIndex;
import com.valor.vod.meta.cache.constant.MetaRedisKey;
import com.valor.vod.meta.cache.model.playlist.NodeDisplay;
import com.valor.vod.meta.cache.model.playlist.Playlist;
import com.valor.vod.meta.cache.model.playlist.PlaylistNode;
import com.valor.vod.meta.cache.model.playlist.PlaylistNodeVersion;
import com.valor.vod.meta.cache.model.playlist.PlaylistTag;
import com.valor.vod.meta.cache.model.playlist.Product;
import com.valor.vod.meta.cache.service.common.PlaylistVersionService;
import com.valor.vod.meta.cache.util.EsCache;
import com.valor.vod.meta.cache.util.MetaCacheContext;
import com.valor.vod.meta.cache.util.MetaCacheUtil;
import com.valor.vod.meta.model.database.constants.playlist.EPlaylistNodeType;
import com.valor.vod.meta.model.database.constants.playlist.ESystemListSubType2;
import common.config.tools.config.ConfigTools3;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class SyncPlaylistService {
    private RedisTemplate<String, Object> redisTemplate;
    private ProtobufRedisTemplate protobufRedisTemplate;
    private EsCache esCache;
    private PlaylistVersionService playlistVersionService;

    @Autowired
    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Autowired
    public void setProtobufRedisTemplate(ProtobufRedisTemplate protobufRedisTemplate) {
        this.protobufRedisTemplate = protobufRedisTemplate;
    }

    @Autowired
    public void setEsCache(EsCache esCache) {
        this.esCache = esCache;
    }

    @Autowired
    public void setPlaylistVersionService(PlaylistVersionService playlistVersionService) {
        this.playlistVersionService = playlistVersionService;
    }

    public RedisTemplate<String, Object> getRedis() {
        return this.redisTemplate;
    }

    @ExceptionConverter
    public void savePlaylistAll(Playlist playlist, List<PlaylistNode> nodes, List<PlaylistTag> tags) {
        this.savePlaylist(playlist);
        this.savePlaylistNodes(playlist.getId(), nodes);
        this.savePlaylistTags(tags);
    }

    @ExceptionConverter
    public void savePlaylist(Playlist playlist) {
        String nplKey;
        String plKey = MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLAYLIST, playlist.getId());
        String string = nplKey = StringUtils.isNotEmpty((CharSequence)playlist.getName()) ? MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_NAME_TO_PLAYLIST_ID, playlist.getName()) : null;
        if (MetaCacheUtil.isOldPLKey()) {
            this.redisTemplate.opsForValue().set((Object)plKey, (Object)playlist);
            if (StringUtils.isNotEmpty((CharSequence)nplKey)) {
                this.redisTemplate.opsForValue().set((Object)nplKey, (Object)playlist);
            }
        } else {
            this.protobufRedisTemplate.opsForValue().set((Object)plKey, (Object)playlist);
            this.playlistVersionService.savePlvKey(plKey);
            if (StringUtils.isNotEmpty((CharSequence)nplKey)) {
                this.protobufRedisTemplate.opsForValue().set((Object)nplKey, (Object)playlist);
                this.playlistVersionService.savePlvKey(nplKey);
            }
        }
    }

    @ExceptionConverter
    public void savePlaylistNodes(long playlistId, List<PlaylistNode> nodes) {
        this.deleteAllNodes(playlistId);
        if (CollectionUtils.isNotEmpty(nodes)) {
            this.addPlaylistNodes(playlistId, nodes);
        }
    }

    @ExceptionConverter
    public void saveOnTheAirLinkedNodes(long playlistId, List<PlaylistNode> nodes) {
        this.deleteOnTheAirLinkedAllNodes(playlistId);
        if (CollectionUtils.isNotEmpty(nodes)) {
            this.addOnTheAirLinkedNodes(playlistId, nodes);
        }
    }

    public void saveRootPlaylistNode(PlaylistNode rootNode) {
        MetaCacheUtil.PLKey key = MetaCacheUtil.splicePLKey(MetaRedisKey.KEY_PLAYLIST_NODE, rootNode.getId());
        if (key.isOld()) {
            this.redisTemplate.opsForValue().set((Object)key.getKey(), (Object)rootNode);
        } else {
            this.protobufRedisTemplate.opsForValue().set((Object)key.getKey(), (Object)rootNode);
            this.playlistVersionService.savePlvKey(key.getKey());
        }
    }

    public void removeRootPlaylistNode(long rootNodeId) {
        MetaCacheUtil.PLKey key = MetaCacheUtil.splicePLKey(MetaRedisKey.KEY_PLAYLIST_NODE, rootNodeId);
        if (key.isOld()) {
            this.redisTemplate.delete((Object)key.getKey());
        } else if (MetaCacheUtil.isPLDelete()) {
            this.protobufRedisTemplate.delete((Object)key.getKey());
        }
    }

    public void saveProduct(Product product) {
        this.redisTemplate.opsForHash().put((Object)"products", (Object)product.getId().toString(), (Object)product);
    }

    public void removeProduct(Long productId) {
        this.redisTemplate.opsForHash().delete((Object)"products", new Object[]{productId.toString()});
    }

    public Product getProduct(Long productId) {
        return (Product)this.redisTemplate.opsForHash().get((Object)"products", (Object)productId.toString());
    }

    public void addPlaylistNodeLink(Long rootNodeId, Long playlistId, Long nodeId) {
        MetaCacheUtil.PLKey key = MetaCacheUtil.splicePLKey(MetaRedisKey.KEY_PLAYLIST_ID_NODE_ID_LINK, rootNodeId, playlistId);
        if (key.isOld()) {
            this.redisTemplate.opsForSet().add((Object)key.getKey(), new Object[]{nodeId});
        } else {
            this.protobufRedisTemplate.opsForSet().add((Object)key.getKey(), new Object[]{nodeId});
            this.playlistVersionService.savePlvKey(key.getKey());
        }
    }

    public void removePlaylistNodeLink(Long rootNodeId, Long playlistId, Long nodeId) {
        MetaCacheUtil.PLKey key = MetaCacheUtil.splicePLKey(MetaRedisKey.KEY_PLAYLIST_ID_NODE_ID_LINK, rootNodeId, playlistId);
        if (key.isOld()) {
            if (nodeId == null) {
                this.redisTemplate.delete((Object)key.getKey());
            } else {
                this.redisTemplate.opsForSet().remove((Object)key.getKey(), new Object[]{nodeId});
            }
        } else if (MetaCacheUtil.isPLDelete()) {
            if (nodeId == null) {
                this.protobufRedisTemplate.delete((Object)key.getKey());
            } else {
                this.protobufRedisTemplate.opsForSet().remove((Object)key.getKey(), new Object[]{nodeId});
            }
        }
    }

    public void removePlaylist(Playlist playlist) {
        String nplKey;
        String plKey = MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLAYLIST, playlist.getId());
        String string = nplKey = StringUtils.isNotEmpty((CharSequence)playlist.getName()) ? MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_NAME_TO_PLAYLIST_ID, playlist.getName()) : null;
        if (MetaCacheUtil.isOldPLKey()) {
            this.redisTemplate.delete((Object)plKey);
            if (StringUtils.isNotEmpty((CharSequence)nplKey)) {
                this.redisTemplate.delete((Object)nplKey);
            }
        } else if (MetaCacheUtil.isPLDelete()) {
            this.protobufRedisTemplate.delete((Object)plKey);
            if (StringUtils.isNotEmpty((CharSequence)nplKey)) {
                this.protobufRedisTemplate.delete((Object)nplKey);
            }
        }
    }

    public void removePlaylistNodes(long playlistId, List<PlaylistNode> nodes) {
        this.deleteAllNodes(playlistId);
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        List nodeKeys = nodes.stream().map(e -> MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLAYLIST_NODE, e.getId())).collect(Collectors.toList());
        List plniKeys = nodes.stream().filter(e -> Objects.equals(e.getNodeType(), EPlaylistNodeType.PLAYLIST)).map(e -> MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLAYLIST_ID_TO_NODE_ID, e.getVmsId())).collect(Collectors.toList());
        if (MetaCacheUtil.isOldPLKey()) {
            this.redisTemplate.delete(nodeKeys);
            this.redisTemplate.delete(plniKeys);
        } else if (MetaCacheUtil.isPLDelete()) {
            this.protobufRedisTemplate.delete(nodeKeys);
            this.protobufRedisTemplate.delete(plniKeys);
        }
    }

    public void removeNodeDisplays(Long productId, List<Long> nodeIds) {
        nodeIds.forEach(e -> {
            MetaCacheUtil.PLKey key = MetaCacheUtil.splicePLKey(MetaRedisKey.KEY_NODE_DISPLAY, e);
            if (key.isOld()) {
                this.redisTemplate.opsForHash().delete((Object)key.getKey(), new Object[]{productId.toString()});
            } else if (MetaCacheUtil.isPLDelete()) {
                this.protobufRedisTemplate.opsForHash().delete((Object)key.getKey(), new Object[]{productId.toString()});
            }
        });
    }

    public void removePlaylistTags(Long productId, List<Long> nodeIds) {
        nodeIds.forEach(e -> {
            MetaCacheUtil.PLKey key = MetaCacheUtil.splicePLKey(MetaRedisKey.KEY_PLAYLIST_TAGS, e);
            if (key.isOld()) {
                this.redisTemplate.opsForHash().delete((Object)key.getKey(), new Object[]{productId.toString()});
            } else {
                this.protobufRedisTemplate.opsForHash().delete((Object)key.getKey(), new Object[]{productId.toString()});
            }
        });
    }

    public void saveSysPlaylistNode(long rootNodeId, String subType, String id, PlaylistNode playlistNode) {
        MetaCacheUtil.PLKey key = MetaCacheUtil.splicePLKey(MetaRedisKey.KEY_SYSTEM_LIST, rootNodeId, subType);
        if (Objects.equals(ESystemListSubType2.POPULAR_VIDEOS.name(), subType)) {
            if (key.isOld()) {
                this.redisTemplate.opsForValue().set((Object)key.getKey(), (Object)playlistNode);
            } else {
                this.protobufRedisTemplate.opsForValue().set((Object)key.getKey(), (Object)playlistNode);
                this.playlistVersionService.savePlvKey(key.getKey());
            }
        } else if (key.isOld()) {
            this.redisTemplate.opsForHash().put((Object)key.getKey(), (Object)id, (Object)playlistNode);
        } else {
            this.protobufRedisTemplate.opsForHash().put((Object)key.getKey(), (Object)id, (Object)playlistNode);
            this.playlistVersionService.savePlvKey(key.getKey());
        }
    }

    public void removeSysPlaylistNode(long rootNodeId, String subType, String id) {
        MetaCacheUtil.PLKey key = MetaCacheUtil.splicePLKey(MetaRedisKey.KEY_SYSTEM_LIST, rootNodeId, subType);
        if (Objects.equals(ESystemListSubType2.POPULAR_VIDEOS.name(), subType)) {
            if (key.isOld()) {
                this.redisTemplate.delete((Object)key.getKey());
            } else if (MetaCacheUtil.isPLDelete()) {
                this.protobufRedisTemplate.delete((Object)key.getKey());
            }
        } else if (key.isOld()) {
            this.redisTemplate.opsForHash().delete((Object)key.getKey(), new Object[]{id});
        } else if (MetaCacheUtil.isPLDelete()) {
            this.protobufRedisTemplate.delete((Object)key.getKey());
        }
    }

    public void saveNodeDisplays(List<NodeDisplay> displays) {
        if (CollectionUtils.isEmpty(displays)) {
            return;
        }
        Map<Long, List<NodeDisplay>> displayMap = displays.stream().collect(Collectors.groupingBy(NodeDisplay::getNodeId));
        displayMap.forEach((k, v) -> {
            MetaCacheUtil.PLKey key = MetaCacheUtil.splicePLKey(MetaRedisKey.KEY_NODE_DISPLAY, k);
            Map displayMap2 = v.stream().collect(Collectors.toMap(display -> display.getProductId().toString(), Function.identity(), (v1, v2) -> v2));
            if (key.isOld()) {
                this.redisTemplate.opsForHash().putAll((Object)key.getKey(), displayMap2);
            } else {
                this.protobufRedisTemplate.opsForHash().putAll((Object)key.getKey(), displayMap2);
                this.playlistVersionService.savePlvKey(key.getKey());
            }
        });
    }

    @ExceptionConverter
    public void mergePlaylistNodesBySortNo(long playlistId, List<PlaylistNode> nodes) {
        this.removeNodesBySortNo(playlistId, nodes);
        this.addPlaylistNodes(playlistId, nodes);
    }

    @ExceptionConverter
    public void removeNodesBySortNo(long playlistId, List<PlaylistNode> nodes) {
        List nodeKeys = nodes.stream().map(e -> MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLAYLIST_NODE, e.getId())).collect(Collectors.toList());
        List plniKeys = nodes.stream().filter(e -> Objects.equals(e.getNodeType(), EPlaylistNodeType.PLAYLIST)).map(e -> MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLAYLIST_ID_TO_NODE_ID, e.getVmsId())).collect(Collectors.toList());
        if (MetaCacheUtil.isOldPLKey()) {
            this.redisTemplate.delete(nodeKeys);
            this.redisTemplate.delete(plniKeys);
        } else if (MetaCacheUtil.isPLDelete()) {
            this.protobufRedisTemplate.delete(nodeKeys);
            this.protobufRedisTemplate.delete(plniKeys);
        }
        PlaylistNodeVersion ver = (PlaylistNodeVersion)MetaCacheContext.getContext().get("rootNodeVersion");
        BoolQueryBuilder bqb = new BoolQueryBuilder();
        nodes.forEach(node -> {
            BoolQueryBuilder subQuery = new BoolQueryBuilder();
            subQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"rootNodeId", (Object)ver.getPlaylistNodeId()));
            subQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"parentPlaylistId", (long)playlistId));
            subQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"vmsId", (long)node.getVmsId()));
            subQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"nodeType", (String)node.getNodeType().name()));
            bqb.should((QueryBuilder)subQuery);
        });
        SearchSourceBuilder ssb = new SearchSourceBuilder();
        ssb.query((QueryBuilder)bqb);
        this.esCache.performDeleteByQuery(this.getPlaylistNodeIndexName(), "playlist_node", ssb.toString());
    }

    @ExceptionConverter
    public void savePlaylistTags(List<PlaylistTag> tags) {
        if (CollectionUtils.isEmpty(tags)) {
            return;
        }
        Map<Long, Map<String, List<PlaylistTag>>> tagsMap = tags.stream().collect(Collectors.groupingBy(PlaylistTag::getNodeId, Collectors.groupingBy(e -> e.getProductId().toString())));
        if (MetaCacheUtil.isOldPLKey()) {
            tagsMap.forEach((k, v) -> this.redisTemplate.opsForHash().putAll((Object)MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLAYLIST_TAGS, k), v));
        } else {
            tagsMap.forEach((k, v) -> {
                String key = MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLAYLIST_TAGS, k);
                this.protobufRedisTemplate.opsForHash().putAll((Object)key, v);
                this.playlistVersionService.savePlvKey(key);
            });
        }
    }

    private void addPlaylistNodes(long playlistId, List<PlaylistNode> nodes) {
        this.addPlaylistNodes(nodes);
        PlaylistNodeVersion ver = (PlaylistNodeVersion)MetaCacheContext.getContext().get("rootNodeVersion");
        List<IDocument> playlistNodeIndices = nodes.stream().map(playlistNode -> {
            PlaylistNodeIndex index = new PlaylistNodeIndex();
            index.setId(Long.valueOf(playlistNode.getId()));
            index.setParentPlaylistId(Long.valueOf(playlistId));
            index.setNodeType(playlistNode.getNodeType().name());
            index.setExtra(playlistNode.getExtra());
            index.setVmsId(Long.valueOf(playlistNode.getVmsId()));
            index.setSortNo(Integer.valueOf(playlistNode.getSortNo()));
            index.setRootNodeId(ver.getPlaylistNodeId());
            return index;
        }).collect(Collectors.toList());
        this.esCache.upserts(playlistNodeIndices, this.getPlaylistNodeIndexName(), "playlist_node");
    }

    private void addOnTheAirLinkedNodes(long playlistId, List<PlaylistNode> nodes) {
        this.addPlaylistNodes(nodes);
        PlaylistNodeVersion ver = (PlaylistNodeVersion)MetaCacheContext.getContext().get("rootNodeVersion");
        List<IDocument> playlistNodeIndices = nodes.stream().map(playlistNode -> {
            PlaylistNodeIndex index = new PlaylistNodeIndex();
            index.setId(Long.valueOf(playlistNode.getId()));
            index.setParentPlaylistId(Long.valueOf(playlistId));
            index.setNodeType(playlistNode.getNodeType().name());
            index.setExtra(playlistNode.getExtra());
            index.setVmsId(Long.valueOf(playlistNode.getVmsId()));
            index.setSortNo(Integer.valueOf(playlistNode.getSortNo()));
            index.setRootNodeId(ver.getPlaylistNodeId());
            index.setType("lineked");
            return index;
        }).collect(Collectors.toList());
        this.esCache.upserts(playlistNodeIndices, this.getPlaylistNodeIndexName(), "playlist_node");
    }

    private void addPlaylistNodes(List<PlaylistNode> nodes) {
        Map<String, Long> playlistNodeMap = nodes.stream().filter(e -> Objects.equals(e.getNodeType(), EPlaylistNodeType.PLAYLIST)).collect(Collectors.toMap(e -> MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLAYLIST_ID_TO_NODE_ID, e.getVmsId()), PlaylistNode::getId, (v1, v2) -> v2));
        Map nodeMap = nodes.stream().filter(e -> Objects.equals(e.getNodeType(), EPlaylistNodeType.PLAYLIST)).collect(Collectors.toMap(e -> MetaCacheUtil.splicePLKeyStr(MetaRedisKey.KEY_PLAYLIST_NODE, e.getId()), Function.identity(), (v1, v2) -> v2));
        if (MetaCacheUtil.isOldPLKey()) {
            this.redisTemplate.opsForValue().multiSet(playlistNodeMap);
            this.redisTemplate.opsForValue().multiSet(nodeMap);
        } else {
            this.protobufRedisTemplate.opsForValue().multiSet(playlistNodeMap);
            this.protobufRedisTemplate.opsForValue().multiSet(nodeMap);
            this.playlistVersionService.savePlvKey(playlistNodeMap.keySet());
            this.playlistVersionService.savePlvKey(nodeMap.keySet());
        }
    }

    private void deleteAllNodes(long playlistId) {
        PlaylistNodeVersion ver = (PlaylistNodeVersion)MetaCacheContext.getContext().get("rootNodeVersion");
        BoolQueryBuilder bqb = new BoolQueryBuilder();
        bqb.must((QueryBuilder)QueryBuilders.termQuery((String)"rootNodeId", (Object)ver.getPlaylistNodeId()));
        bqb.must((QueryBuilder)QueryBuilders.termQuery((String)"parentPlaylistId", (long)playlistId));
        bqb.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)"lineked"));
        SearchSourceBuilder ssb = new SearchSourceBuilder();
        ssb.query((QueryBuilder)bqb);
        this.esCache.performDeleteByQuery(this.getPlaylistNodeIndexName(), "playlist_node", ssb.toString());
    }

    private void deleteOnTheAirLinkedAllNodes(long playlistId) {
        PlaylistNodeVersion ver = (PlaylistNodeVersion)MetaCacheContext.getContext().get("rootNodeVersion");
        BoolQueryBuilder bqb = new BoolQueryBuilder();
        bqb.must((QueryBuilder)QueryBuilders.termQuery((String)"rootNodeId", (Object)ver.getPlaylistNodeId()));
        bqb.must((QueryBuilder)QueryBuilders.termQuery((String)"parentPlaylistId", (long)playlistId));
        bqb.must((QueryBuilder)QueryBuilders.termQuery((String)"type", (String)"lineked"));
        SearchSourceBuilder ssb = new SearchSourceBuilder();
        ssb.query((QueryBuilder)bqb);
        this.esCache.performDeleteByQuery(this.getPlaylistNodeIndexName(), "playlist_node", ssb.toString());
    }

    private void deleteAllNodes(long playlistId, MetaRedisKey subNodesKey) {
        MetaCacheUtil.PLKey key = MetaCacheUtil.splicePLKey(subNodesKey, playlistId);
        if (key.isOld()) {
            this.redisTemplate.delete((Object)key.getKey());
        } else if (MetaCacheUtil.isPLDelete()) {
            this.protobufRedisTemplate.delete((Object)key.getKey());
        }
    }

    private String getPlaylistNodeIndexName() {
        return ConfigTools3.getString((String)"index.playlistNode", (String)"playlist_node");
    }
}

