/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.util;

import com.valor.vod.common.tools.type.CollectionUtils;
import com.valor.vod.es.api.client.ESIndexApi;
import com.valor.vod.es.api.client.ESSearchApi;
import com.valor.vod.es.api.model.client.ESProperties;
import com.valor.vod.es.api.model.service.base.IDocument;
import com.valor.vod.es.api.model.service.search.ESApiResponse;
import com.valor.vod.es.api.model.service.search.ESIdResponse;
import com.valor.vod.es.api.model.service.search.ESSearchParameter;
import common.base.tools.stat.MetricTools;
import common.base.tools.stat.TimeStatisticsTools;
import common.config.tools.config.ConfigTools3;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.springframework.stereotype.Service;

@Service
public class EsCache {
    private ESIndexApi esIndexApi = null;
    private ESSearchApi esSearchApi = null;

    @PostConstruct
    public void init() {
        ESProperties esProperties = ESProperties.builder().clusterName(ConfigTools3.getString((String)"mfc.detail.es.cluster.name")).host(ConfigTools3.getAsList((String)"mfc.detail.es.cluster.server.address")).port(ConfigTools3.getInt((String)"mfc.detail.es.cluster.server.port", (Integer)9201).intValue()).protocol(ConfigTools3.getString((String)"mfc.detail.es.cluster.server.protocol")).userName(ConfigTools3.getString((String)"mfc.detail.es.cluster.server.username")).password(ConfigTools3.getString((String)"mfc.detail.es.cluster.server.password")).serverName(ConfigTools3.getString((String)"mfc.detail.es.cluster.server.serverName")).bulkSize(ConfigTools3.getInt((String)"mfc.detail.es.cluster.server.bulkSize", (Integer)200).intValue());
        this.esIndexApi = new ESIndexApi(esProperties);
        this.esSearchApi = new ESSearchApi(esProperties);
    }

    public void upserts(List<IDocument> docs, String index, String type) {
        if (CollectionUtils.isNullOrEmpty(docs)) {
            return;
        }
        this.esIndexApi.bulkUpdateIndex(index, type, docs, WriteRequest.RefreshPolicy.NONE);
    }

    public void upserts(String index, String type, List<IDocument> docs) {
        this.esIndexApi.bulkUpdateIndex(index, type, docs);
    }

    public void upserts(String index, String type, List<IDocument> docs, WriteRequest.RefreshPolicy refreshPolicy) {
        this.esIndexApi.bulkUpdateIndex(index, type, docs, refreshPolicy);
    }

    public void bulkRemoveIndexByQueryById(String index, String type, List<Long> ids) {
        this.esIndexApi.bulkRemoveIndexByQueryById(index, type, ids);
    }

    public void performDeleteByQuery(String index, String type, String queryJson) {
        this.esIndexApi.perfromDeleteByQuery(index, type, queryJson);
    }

    public void removes(Set<String> docIdSet, String index, String type) {
        if (CollectionUtils.isNullOrEmpty(docIdSet)) {
            return;
        }
        this.esIndexApi.bulkRemoveIndex(index, type, docIdSet, WriteRequest.RefreshPolicy.NONE);
    }

    public <T> Set<T> search(ESSearchParameter parameter) {
        Set set;
        long curTS = System.currentTimeMillis();
        ESApiResponse response = null;
        try {
            Set ts;
            response = this.esSearchApi.search(parameter);
            set = ts = response.getSource();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                TimeStatisticsTools.addTime((String)String.format("ES-search-%s", parameter.getType()), (int)1, (long)(System.currentTimeMillis() - curTS));
                MetricTools.logESTime((String)parameter.getType(), (String)"search", (int)1, (long)(System.currentTimeMillis() - curTS));
                throw throwable;
            }
        }
        TimeStatisticsTools.addTime((String)String.format("ES-search-%s", parameter.getType()), (int)1, (long)(System.currentTimeMillis() - curTS));
        MetricTools.logESTime((String)parameter.getType(), (String)"search", (int)1, (long)(System.currentTimeMillis() - curTS));
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> Set<T> searchWithScroll(ESSearchParameter parameter) {
        LinkedHashSet linkedHashSet;
        long curTS = System.currentTimeMillis();
        LinkedHashSet result = new LinkedHashSet();
        try {
            String timeLimit = ConfigTools3.getString((String)"es.scroll.timeLimit", (String)"1m");
            ESApiResponse response = this.esSearchApi.searchWithScroll(parameter, timeLimit);
            Set ts = response.getSource();
            String scrollId = response.getScrollId();
            while (ts.size() > 0) {
                result.addAll(ts);
                response = this.esSearchApi.scroll(scrollId, timeLimit);
                ts = response.getSource();
            }
            this.esSearchApi.clearScroll(scrollId);
            linkedHashSet = result;
        }
        catch (Throwable throwable) {
            TimeStatisticsTools.addTime((String)String.format("ES-search-%s", parameter.getType()), (int)1, (long)(System.currentTimeMillis() - curTS));
            MetricTools.logESTime((String)parameter.getType(), (String)"search", (int)1, (long)(System.currentTimeMillis() - curTS));
            throw throwable;
        }
        TimeStatisticsTools.addTime((String)String.format("ES-search-%s", parameter.getType()), (int)1, (long)(System.currentTimeMillis() - curTS));
        MetricTools.logESTime((String)parameter.getType(), (String)"search", (int)1, (long)(System.currentTimeMillis() - curTS));
        return linkedHashSet;
    }

    public List<String> searchId(ESSearchParameter parameter) {
        List list;
        long curTS = System.currentTimeMillis();
        ESIdResponse response = null;
        try {
            List ts;
            response = this.esSearchApi.searchId(parameter);
            list = ts = response.getSource();
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                TimeStatisticsTools.addTime((String)String.format("ES-searchId-%s", parameter.getType()), (int)1, (long)(System.currentTimeMillis() - curTS));
                MetricTools.logESTime((String)parameter.getType(), (String)"searchId", (int)1, (long)(System.currentTimeMillis() - curTS));
                throw throwable;
            }
        }
        TimeStatisticsTools.addTime((String)String.format("ES-searchId-%s", parameter.getType()), (int)1, (long)(System.currentTimeMillis() - curTS));
        MetricTools.logESTime((String)parameter.getType(), (String)"searchId", (int)1, (long)(System.currentTimeMillis() - curTS));
        return list;
    }

    public <T> Set<T> search(ESSearchParameter parameter, int[] totalCount) {
        Set set;
        long curTS = System.currentTimeMillis();
        ESApiResponse response = null;
        try {
            response = this.esSearchApi.search(parameter);
            Set ts = response.getSource();
            totalCount[0] = (int)response.getHitTotal();
            set = ts;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                TimeStatisticsTools.addTime((String)String.format("ES-search-%s", parameter.getType()), (int)1, (long)(System.currentTimeMillis() - curTS));
                MetricTools.logESTime((String)parameter.getType(), (String)"search", (int)1, (long)(System.currentTimeMillis() - curTS));
                throw throwable;
            }
        }
        TimeStatisticsTools.addTime((String)String.format("ES-search-%s", parameter.getType()), (int)1, (long)(System.currentTimeMillis() - curTS));
        MetricTools.logESTime((String)parameter.getType(), (String)"search", (int)1, (long)(System.currentTimeMillis() - curTS));
        return set;
    }

    public List<String> searchId(ESSearchParameter parameter, int[] totalCount) {
        List list;
        long curTS = System.currentTimeMillis();
        ESIdResponse response = null;
        try {
            response = this.esSearchApi.searchId(parameter);
            List ts = response.getSource();
            totalCount[0] = (int)response.getHitTotal();
            list = ts;
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                TimeStatisticsTools.addTime((String)String.format("ES-searchId-%s", parameter.getType()), (int)1, (long)(System.currentTimeMillis() - curTS));
                MetricTools.logESTime((String)parameter.getType(), (String)"searchId", (int)1, (long)(System.currentTimeMillis() - curTS));
                throw throwable;
            }
        }
        TimeStatisticsTools.addTime((String)String.format("ES-searchId-%s", parameter.getType()), (int)1, (long)(System.currentTimeMillis() - curTS));
        MetricTools.logESTime((String)parameter.getType(), (String)"searchId", (int)1, (long)(System.currentTimeMillis() - curTS));
        return list;
    }

    public ESIdResponse searchIdResponse(ESSearchParameter parameter) {
        ESIdResponse eSIdResponse;
        long curTS = System.currentTimeMillis();
        ESIdResponse response = null;
        try {
            eSIdResponse = response = this.esSearchApi.searchId(parameter);
        }
        catch (Exception e) {
            try {
                throw e;
            }
            catch (Throwable throwable) {
                TimeStatisticsTools.addTime((String)String.format("ES-searchIdResponse-%s", parameter.getType()), (int)1, (long)(System.currentTimeMillis() - curTS));
                MetricTools.logESTime((String)parameter.getType(), (String)"searchIdResponse", (int)1, (long)(System.currentTimeMillis() - curTS));
                throw throwable;
            }
        }
        TimeStatisticsTools.addTime((String)String.format("ES-searchIdResponse-%s", parameter.getType()), (int)1, (long)(System.currentTimeMillis() - curTS));
        MetricTools.logESTime((String)parameter.getType(), (String)"searchIdResponse", (int)1, (long)(System.currentTimeMillis() - curTS));
        return eSIdResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResponse searchResponse(SearchSourceBuilder searchSourceBuilder, String index, String type) {
        SearchResponse searchResponse;
        long curTS = System.currentTimeMillis();
        try {
            searchResponse = this.esSearchApi.searchResponse(searchSourceBuilder, index, type);
        }
        catch (Throwable throwable) {
            TimeStatisticsTools.addTime((String)String.format("ES-searchResponse-%s", type), (int)1, (long)(System.currentTimeMillis() - curTS));
            MetricTools.logESTime((String)type, (String)"searchIdResponse", (int)1, (long)(System.currentTimeMillis() - curTS));
            throw throwable;
        }
        TimeStatisticsTools.addTime((String)String.format("ES-searchResponse-%s", type), (int)1, (long)(System.currentTimeMillis() - curTS));
        MetricTools.logESTime((String)type, (String)"searchIdResponse", (int)1, (long)(System.currentTimeMillis() - curTS));
        return searchResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BulkResponse bulkRemoveIndex(String index, String type, List<String> ids) {
        BulkResponse bulkResponse;
        long curTS = System.currentTimeMillis();
        try {
            bulkResponse = this.esIndexApi.bulkRemoveIndex(index, type, ids);
        }
        catch (Throwable throwable) {
            TimeStatisticsTools.addTime((String)String.format("ES-bulkRemoveIndex-%s", type), (int)1, (long)(System.currentTimeMillis() - curTS));
            MetricTools.logESTime((String)type, (String)"bulkRemoveIndex", (int)1, (long)(System.currentTimeMillis() - curTS));
            throw throwable;
        }
        TimeStatisticsTools.addTime((String)String.format("ES-bulkRemoveIndex-%s", type), (int)1, (long)(System.currentTimeMillis() - curTS));
        MetricTools.logESTime((String)type, (String)"bulkRemoveIndex", (int)1, (long)(System.currentTimeMillis() - curTS));
        return bulkResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createIndexIfAbsent(String index, String source) throws IOException {
        long curTS = System.currentTimeMillis();
        try {
            boolean exist = this.esIndexApi.indexExists(index);
            if (exist) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.esIndexApi.createIndex(index, source);
            return bl;
        }
        finally {
            TimeStatisticsTools.addTime((String)"ES-createIndexIfAbsent", (int)1, (long)(System.currentTimeMillis() - curTS));
            MetricTools.logESTime((String)index, (String)"createIndexIfAbsent", (int)1, (long)(System.currentTimeMillis() - curTS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getIndexesByAlias(String alias) throws IOException {
        long curTS = System.currentTimeMillis();
        try {
            Set set = this.esIndexApi.getIndexesByAlias(alias);
            return set;
        }
        finally {
            TimeStatisticsTools.addTime((String)"ES-getIndexesByAlias", (int)1, (long)(System.currentTimeMillis() - curTS));
            MetricTools.logESTime((String)alias, (String)"getIndexesByAlias", (int)1, (long)(System.currentTimeMillis() - curTS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateAlias(String alias, List<String> delList, List<String> addList) throws IOException {
        long curTS = System.currentTimeMillis();
        try {
            boolean bl = this.esIndexApi.updateIndexAlias(alias, delList, addList);
            return bl;
        }
        finally {
            TimeStatisticsTools.addTime((String)"ES-updateAlias", (int)1, (long)(System.currentTimeMillis() - curTS));
            MetricTools.logESTime((String)alias, (String)"updateAlias", (int)1, (long)(System.currentTimeMillis() - curTS));
        }
    }
}

