/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.util;

import com.valor.vod.meta.cache.constant.MetaRedisKey;
import com.valor.vod.meta.cache.model.playlist.PlaylistNodeVersion;
import com.valor.vod.meta.cache.util.MetaCacheContext;

public final class MetaCacheUtil {
    public static String getPlnPrefix() {
        PlaylistNodeVersion ver = (PlaylistNodeVersion)MetaCacheContext.getContext().get("rootNodeVersion");
        return MetaCacheUtil.getPlnPrefix(ver);
    }

    public static String getPlnPrefix(PlaylistNodeVersion ver) {
        if (ver == null) {
            return null;
        }
        return "pnv-" + ver.getPlaylistNodeId() + "-" + ver.getVersion() + ":";
    }

    public static boolean isOldPLKey() {
        return MetaCacheUtil.getPlnPrefix() == null;
    }

    public static boolean isPLDelete() {
        Object o = MetaCacheContext.getContext().get("rootNodeDelete");
        if (o == null) {
            return false;
        }
        String os = o.toString();
        return "true".equalsIgnoreCase(os) || "1".equals(os) || "y".equalsIgnoreCase(os);
    }

    public static String splicePLKeyStr(MetaRedisKey key, Object ... params) {
        PlaylistNodeVersion pnv = (PlaylistNodeVersion)MetaCacheContext.getContext().get("rootNodeVersion");
        return MetaCacheUtil.splicePLKeyStr(key, pnv, params);
    }

    public static String splicePLKeyStr(MetaRedisKey key, PlaylistNodeVersion pnv, Object ... params) {
        String prefix = MetaCacheUtil.getPlnPrefix(pnv);
        String val = key.key(params);
        if (prefix == null) {
            return val;
        }
        return prefix + val;
    }

    public static PLKey splicePLKey(MetaRedisKey key, Object ... params) {
        String prefix = MetaCacheUtil.getPlnPrefix();
        String val = key.key(params);
        if (prefix == null) {
            return new PLKey(true, val);
        }
        return new PLKey(false, prefix + val);
    }

    public static class PLKey {
        boolean old;
        String key;

        public PLKey(boolean old, String key) {
            this.old = old;
            this.key = key;
        }

        public boolean isOld() {
            return this.old;
        }

        public String getKey() {
            return this.key;
        }
    }
}

