package com.valor.vod.meta.cache.constant;

import java.text.MessageFormat;

/**
 * Meta缓存KEY枚举
 *
 * @author Bruce Wu
 * @since 2022-09-30
 */
public enum MetaRedisKey implements MetaRedisPrefix {
    /** pl:[playlist#id] -> playlist | string */
    KEY_PLAYLIST(PLAYLIST + "{0}"),

    /** pln:[playlist#name] -> playlist | string */
    KEY_NAME_TO_PLAYLIST_ID(NAME_TO_PLAYLIST_ID + "{0}"),

    /** node:[playlist_node#id] -> string playlist_node | string */
    KEY_PLAYLIST_NODE(PLAYLIST_NODE + "{0}"),

    /** nd:[node_display#id] -> node_display | string */
    KEY_NODE_DISPLAY(NODE_DISPLAY + "{0}"),

    /** plni:[playlist_node#vms_id] -> playlist_node#id | string */
    KEY_PLAYLIST_ID_TO_NODE_ID(PLAYLIST_ID_TO_NODE_ID + "{0}"),

    /** tgs:[playlist_node#id] | hash */
    KEY_PLAYLIST_TAGS(PLAYLIST_TAGS + "{0}"),

    /** pini-[playlist_node(root)#id]-[playlist#id] -> [playlist_node#id] | string */
    KEY_PLAYLIST_ID_NODE_ID_LINK(PLAYLIST_ID_NODE_ID_LINK + "{0}-{1}"),

    KEY_SYSTEM_LIST(SYSTEM_LIST + "{0}-{1}"),

    /** node_version:[playlist_node(root)#id] -> playlist_node_version | string */
    KEY_PLAYLIST_NODE_VERSION(NODE_VERSION + "{0}"),

    /** on-the-air -> OnTheAir | hash */
    KEY_ON_THE_AIR(TV_ON_THE_AIR),

    KEY_ON_THE_AIR_LINKED(TV_ON_THE_AIR_LINKED),

    /** prefix + plv_keys -> keys | set */
    KEY_PLV_KEYS(PLAYLIST_VERSION_KEYS),
    ;

    final String format;

    MetaRedisKey(String format) {
        this.format = format;
    }

    public String getFormat() {
        return format;
    }

    /**
     * 根据传入参数生成KEY
     *
     * @param objs 填充参数
     * @return KEY
     */
    public String key(Object... objs) {
        if (objs == null || objs.length == 0) {
            return format;
        }
        Object[] arguments = new Object[objs.length];
        for (int i = 0; i < objs.length; i++) {
            arguments[i] = String.valueOf(objs[i]);
        }
        return MessageFormat.format(format, arguments);
    }
}
