package com.valor.vod.meta.cache.model.playlist;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.valor.vod.meta.model.database.constants.playlist.EPlaylistNodeType;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.ToString;

/**
 * 播放列表节点类
 *
 * @author Tom Tang
 * @date 2021/7/8
 * @since 3.0.0
 */
@Getter
@ToString
@EqualsAndHashCode(onlyExplicitlyIncluded = true)
@JsonIgnoreProperties(value = "sortNo", allowSetters = true)
public class PlaylistNode {

    /**
     * 节点ID
     */
    @EqualsAndHashCode.Include
    private long id;

    /**
     * 节点类型，枚举值：PLAYLIST/VIDEO/PERSON
     */
    private EPlaylistNodeType nodeType;

    /**
     * 子节点的vms_id，playlistId/videoId/personId其中之一
     */
    private long vmsId;

    /**
     * 排序号，节点升序排列
     */
    private int sortNo;

    private String extra;

    private boolean subHasTimingConfig;

    private Long startTimeStamp;

    private Long endTimeStamp;

    protected PlaylistNode() {}

    public static PlaylistNode create() {
        return new PlaylistNode();
    }

    public PlaylistNode setId(long id) {
        this.id = id;
        return this;
    }

    public PlaylistNode setNodeType(EPlaylistNodeType nodeType) {
        this.nodeType = nodeType;
        return this;
    }

    public PlaylistNode setVmsId(long vmsId) {
        this.vmsId = vmsId;
        return this;
    }

    public PlaylistNode setSortNo(int sortNo) {
        this.sortNo = sortNo;
        return this;
    }

    public PlaylistNode setExtra(String extra) {
        this.extra = extra;
        return this;
    }

    public PlaylistNode setSubHasTimingConfig(boolean subHasTimingConfig) {
        this.subHasTimingConfig = subHasTimingConfig;
        return this;
    }

    public PlaylistNode setStartTimeStamp(Long startTimeStamp) {
        this.startTimeStamp = startTimeStamp;
        return this;
    }

    public PlaylistNode setEndTimeStamp(Long endTimeStamp) {
        this.endTimeStamp = endTimeStamp;
        return this;
    }
}
