package com.valor.vod.meta.cache.model.playlist;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.valor.vod.api.model.tag.ETagContentType;
import com.valor.vod.api.model.tag.ETagPostion;
import com.valor.vod.api.model.tag.ETagType;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.io.Serializable;

/**
 * 播放列表Tag类
 *
 * @author Tom Tang
 * @date 2021/7/28
 * @since 3.0.0
 */
@Getter
@ToString
@NoArgsConstructor(staticName = "create")
public class PlaylistTag implements Serializable {

    private static final long serialVersionUID = 1667115439592738572L;
    @JsonIgnore
    private Long nodeId;

    @JsonIgnore
    private Long productId;

    private ETagPostion position;

    private Integer seq;

    private String content;

    private String contentFilter;

    private String contentFrom;

    private ETagContentType contentType;

    private ETagType type;

    private String acl;

    private String dataType;

    @JsonIgnore
    public Long getNodeId() {
        return nodeId;
    }

    @JsonProperty
    public PlaylistTag setNodeId(Long nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @JsonIgnore
    public Long getProductId() {
        return productId;
    }

    @JsonProperty
    public PlaylistTag setProductId(Long productId) {
        this.productId = productId;
        return this;
    }

    public PlaylistTag setPosition(ETagPostion position) {
        this.position = position;
        return this;
    }

    public PlaylistTag setSeq(Integer seq) {
        this.seq = seq;
        return this;
    }

    public PlaylistTag setContent(String content) {
        this.content = content;
        return this;
    }

    public PlaylistTag setContentFilter(String contentFilter) {
        this.contentFilter = contentFilter;
        return this;
    }

    public PlaylistTag setContentFrom(String contentFrom) {
        this.contentFrom = contentFrom;
        return this;
    }

    public PlaylistTag setContentType(ETagContentType contentType) {
        this.contentType = contentType;
        return this;
    }

    public PlaylistTag setType(ETagType type) {
        this.type = type;
        return this;
    }

    public PlaylistTag setAcl(String acl) {
        this.acl = acl;
        return this;
    }

    public PlaylistTag setDataType(String dataType) {
        this.dataType = dataType;
        return this;
    }
}
