package com.valor.vod.meta.cache.model.playlist;

import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author ted
 * @date 2021/10/12
 */
@Getter
@ToString
@NoArgsConstructor(staticName = "create")
public class Product implements Serializable {
    private static final long serialVersionUID = -386047570971024848L;
    /**
     * 产品id
     */
    private Long id;
    /**
     * 布局树根节点id
     */
    private Long rootNodeId;
    /**
     * 产品code
     */
    private String productCode;
    /**
     * 最大版本
     */
    private Long appMaxVer;
    /**
     * 最小版本
     */
    private Long appMinVer;
    /**
     * 地区
     */
    private String region;
    private String appId;
    private Integer defaultTree;
    private Integer productMode;

    public Product setId(Long id) {
        this.id = id;
        return this;
    }

    public Product setRootNodeId(Long rootNodeId) {
        this.rootNodeId = rootNodeId;
        return this;
    }

    public Product setAppMaxVer(Long appMaxVer) {
        this.appMaxVer = appMaxVer;
        return this;
    }

    public Product setAppMinVer(Long appMinVer) {
        this.appMinVer = appMinVer;
        return this;
    }

    public Product setRegion(String region) {
        this.region = region;
        return this;
    }

    public Product setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public Product setDefaultTree(Integer defaultTree) {
        this.defaultTree = defaultTree;
        return this;
    }

    public Product setProductCode(String productCode) {
        this.productCode = productCode;
        return this;
    }

    public void setProductMode(Integer productMode) {
        this.productMode = productMode;
    }
}

