package com.valor.vod.meta.cache.service.common;

import com.valor.vod.meta.cache.util.RedisCache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class QueryMediaService<T> {

    RedisCache redisCache;

    public QueryMediaService(RedisCache redisCache) {
        this.redisCache = redisCache;
    }

    private Set<String> getKeySet(String prefix, Set<Long> idSet) {
        Set<String> keySet = new HashSet<>();
        for (Long id : idSet) {
            String key = prefix + id;
            keySet.add(key);
        }
        return keySet;
    }


    public Map<Long, T> getObjectByVmsIds(String prefix, Set<Long> idSet) {
        Set<String> keySet = getKeySet(prefix, idSet);
        Map<String, T> map = redisCache.mGet(keySet);
        Map<Long, T> resultMap = new HashMap<>();
        for (Map.Entry<String, T> e : map.entrySet()) {
            String key = e.getKey();
            Long id = Long.parseLong(key.substring(prefix.length()));
            resultMap.put(id, e.getValue());
        }
        return resultMap;
    }


    public Map<Long, Set<Long>> getSetObjectByVmsIds(String prefix, Set<Long> idSet) {
        Set<String> keyset = getKeySet(prefix, idSet);
        Map<String, Set<Integer>> map = redisCache.mMembers(keyset);
        Map<Long, Set<Long>> resultMap = new HashMap<>();
        map.forEach((k, v) -> resultMap.put(Long.parseLong(k.substring(prefix.length())),
            v.stream().map(vl -> Long.valueOf(String.valueOf(vl))).collect(Collectors.toSet())));
        return resultMap;
    }
}
