package com.valor.vod.meta.cache.service.query;

import com.google.common.base.Joiner;
import com.valor.vod.meta.cache.constant.LocalizationType;
import com.valor.vod.meta.cache.model.RegionDTO;
import com.valor.vod.meta.model.database.dao.MetaDao;
import com.valor.vod.meta.model.database.ddo.playlist.LocalizationDDO;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistDDO;
import com.valor.vod.meta.model.database.ddo.playlist.Region;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
@Slf4j
public class PlayListDealLocalService {
    @Autowired
    private MetaDao metaDao;

    public void dealLocalTag(PlaylistDDO playlistDdo) {
        String target = playlistDdo.getTarget();
        if (StringUtils.isBlank(target) || !target.contains("local:")) {
            return;
        }
        String[] split = target.split("local:");
        Pair<String, String> pair = cropLocalName(split[1]);
        LocalizationDDO local = metaDao.queryLocalizationByName(pair.getLeft());
        if (local == null) {
            return;
        }
        String content;
        if (LocalizationType.LOCAL_SUBTITLE.desc().equals(local.getType())) {
            content = local.getLocalContent().replaceAll(",", "-");
        } else {
            // 转换国家code为国家id
            List<Region> dbRegions = metaDao.loadRegions();
            List<RegionDTO> regionDTOS = dbRegions.stream().map(this::convertRegion2Dto).collect(Collectors.toList());
            String[] countries = local.getLocalContent().split(",");
            List<Long> list = new ArrayList<>(countries.length);
            for (String country : countries) {
                for (RegionDTO dto : regionDTOS) {
                    if (dto.getCode().equals(country)) {
                        list.add(dto.getId());
                        break;
                    }
                }
            }
            content = Joiner.on("-").join(list);
        }
        String str = split[0] + "local:" +
                LocalizationType.getValue(local.getType()) + "|" +
                content + "|" +
                pair.getRight();
        playlistDdo.setTarget(str);
    }


    private Pair<String, String> cropLocalName(String target) {
        for (int i = 0; i < target.length(); i++) {
            if (target.charAt(i) == ';' || target.charAt(i) == '&') {
                return Pair.of(target.substring(0, i), target.substring(i));
            }
        }
        return Pair.of(target, "");
    }

    private RegionDTO convertRegion2Dto(Region region) {
        RegionDTO regionDTO = new RegionDTO();
        regionDTO.setId(region.getId());
        regionDTO.setName(region.getName());
        regionDTO.setCode(region.getCode());
        regionDTO.setOrder(region.getOrder());
        regionDTO.setContinent(region.getContinent());
        return regionDTO;
    }
}
