package com.valor.vod.meta.cache.service.query;

import com.valor.vod.api.common.SetTool;
import com.valor.vod.meta.cache.model.CloudAcct;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Service
public class QueryCloudAcctService {
    @Autowired
    RedisCache redisCache;

    private Set<String> getKeySet(Set<Long> idSet) {
        Set<String> keySet = new HashSet<>();
        for (Long id : idSet) {
            String key = RedisPrefix.CloudAcct + id;
            keySet.add(key);
        }
        return keySet;
    }

    //cloudAcctLocalCache.getLocalCache().getData(String.valueOf(e.getCid()))
    public Map<Long, CloudAcct> getCloudAcctByCids(Set<Long> cidSet) {
        Set<String> keySet = getKeySet(cidSet);
        Map<String, CloudAcct> detailMap = redisCache.mGet(keySet);
        Map<Long, CloudAcct> resultMap = new HashMap<>();
        for (Map.Entry<String, CloudAcct> e : detailMap.entrySet()) {
            CloudAcct md = e.getValue();
            resultMap.put(md.getCid(), md);
        }
        return resultMap;
    }

    public CloudAcct getCloudAcctByCids(Long cid) {
        Map<Long, CloudAcct> map = getCloudAcctByCids(SetTool.asHashSet(cid));
        return map.getOrDefault(cid, null);
    }


    //cloudAcctSiteAcctCache.getCidBySiteAndAcct(site, acct,defaultValue)
    public Long getCidBySiteAndAcct(String site, String acct) {
        String key = RedisPrefix.CloudAcctAcctSiteCid + site + "_" + acct;
        Long cid = redisCache.get(key);
        return cid;
    }


}
