package com.valor.vod.meta.cache.service.query;

import com.valor.vod.es.api.model.service.media.MediaAward;
import com.valor.vod.meta.cache.service.common.QueryMediaService;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import common.base.tools.stat.TimeStatisticsTools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Service
public class QueryMediaAwardService {

    @Autowired
    RedisCache redisCache;

    QueryMediaService<List<MediaAward>> queryMediaService;

    @PostConstruct
    public void init() {
        queryMediaService = new QueryMediaService<>(redisCache);
    }

    public Map<Long, List<MediaAward>> getMediaAwardByVmsIds(Set<Long> idSet) {
        long beginTime = System.currentTimeMillis();
        Map<Long, List<MediaAward>> result = queryMediaService.getObjectByVmsIds(RedisPrefix.MediaAward, idSet);
        TimeStatisticsTools.addTime(String.format("REDIS-getMediaAwardByVmsIds"), 1, System.currentTimeMillis() - beginTime);
        return result;

    }


}
