package com.valor.vod.meta.cache.service.query;

import com.valor.vod.api.common.SetTool;
import com.valor.vod.es.api.model.service.media.MediaParentsGuide;
import com.valor.vod.meta.cache.service.common.QueryMediaService;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import common.base.tools.stat.TimeStatisticsTools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Service
public class QueryMediaParentsGuideService {

    @Autowired
    RedisCache redisCache;

    QueryMediaService<List<MediaParentsGuide>> queryMediaService;

    @PostConstruct
    public void init() {
        queryMediaService = new QueryMediaService<>(redisCache);
    }


    public Map<Long, List<MediaParentsGuide>> getMediaParentsGuideByVmsIds(Set<Long> idSet) {
        long beginTime = System.currentTimeMillis();
        Map<Long, List<MediaParentsGuide>> result = queryMediaService.getObjectByVmsIds(RedisPrefix.MediaParentsGuide, idSet);
        TimeStatisticsTools.addTime("REDIS-getMediaParentsGuideByVmsIds", 1, System.currentTimeMillis() - beginTime);
        return result;
    }

    public List<MediaParentsGuide> getMediaParentsGuideByVmsId(Long id) {
        Map<Long, List<MediaParentsGuide>> map = getMediaParentsGuideByVmsIds(SetTool.asHashSet(id));
        return map.getOrDefault(id, new ArrayList<>());
    }

}
