package com.valor.vod.meta.cache.service.query;

import com.valor.vod.api.common.SetTool;
import com.valor.vod.common.tools.stat.BeanMethodStatistics;
import com.valor.vod.es.api.model.service.person.Person;
import com.valor.vod.es.api.model.service.person.PersonSearchIndex;
import com.valor.vod.es.api.model.service.search.ESSearchParameter;
import com.valor.vod.meta.cache.util.EsCache;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import common.base.tools.stat.TimeStatisticsTools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class QueryMediaPersonService {
    @Autowired
    RedisCache redisCache;
    @Autowired
    EsCache esCache;

    private Set<String> getKeySet(Set<Long> idSet) {
        Set<String> keySet = new HashSet<>();
        for (Long id : idSet) {
            String key = RedisPrefix.Person + id;
            keySet.add(key);
        }
        return keySet;
    }

    private Set<String> getMetaKeySet(Set<String> metaIdSet) {
        Set<String> keySet = new HashSet<>();
        for (String id : metaIdSet) {
            String key = RedisPrefix.PersonMetaIdId + id;
            keySet.add(key);
        }
        return keySet;
    }

    @BeanMethodStatistics
    public Map<Long, Person> getMediaPersonByIds(Set<Long> idSet) {
        long beginTime = System.currentTimeMillis();
        Set<String> keySet = getKeySet(idSet);
        Map<String, Person> detailMap = redisCache.mGet(keySet);
        Map<Long, Person> resultMap = new HashMap<>();
        for (Map.Entry<String, Person> e : detailMap.entrySet()) {
            Person md = e.getValue();
            resultMap.put(md.getId(), md);
        }
        TimeStatisticsTools.addTime("REDIS-getMediaPersonByIds", 1, System.currentTimeMillis() - beginTime);
        return resultMap;
    }

    public Person getMediaPersonById(Long id) {
        Map<Long, Person> personMap = getMediaPersonByIds(SetTool.asHashSet(id));
        return personMap.getOrDefault(id, null);
    }

    public Long getVmsIdByMetaIds(String metaId) {
        Map<String, Long> map = getVmsIdByMetaIds(SetTool.asHashSet(metaId));
        return map.getOrDefault(metaId, null);
    }

    public Map<String, Long> getVmsIdByMetaIds(Set<String> metaIdSet) {
        long beginTime = System.currentTimeMillis();
        Set<String> keySet = getMetaKeySet(metaIdSet);
        Map<String, Long> detailMap = redisCache.mGet(keySet);
        Map<String, Long> resultMap = new HashMap<>();
        for (Map.Entry<String, Long> e : detailMap.entrySet()) {
            Long vmsId = Long.parseLong(String.valueOf(e.getValue()));
            resultMap.put(e.getKey().substring(RedisPrefix.PersonMetaIdId.length()), vmsId);
        }
        TimeStatisticsTools.addTime("REDIS-getVmsIdByMetaIds", 1, System.currentTimeMillis() - beginTime);
        return resultMap;
    }

    public List<String> getMediaPersonIds(ESSearchParameter parameter, int totalCount[]) {
        return esCache.searchId(parameter, totalCount);
    }

    public Map<Long, Person> getMediaPersonByIndexes(List<PersonSearchIndex> searchIndices) {

        Set<Long> idSet = new HashSet<>();
        for (PersonSearchIndex searchIndex : searchIndices) {
            idSet.add(searchIndex.getId());
        }
        return getMediaPersonByIds(idSet);
    }
}
