package com.valor.vod.meta.cache.service.query;

import com.valor.vod.api.common.SetTool;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import common.base.tools.stat.TimeStatisticsTools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service
public class QueryMediaSimilarService {
    @Autowired
    RedisCache redisCache;

    private Set<String> getKeySet(Set<Long> idSet) {
        Set<String> keySet = new HashSet<>();
        for (Long id : idSet) {
            String key = RedisPrefix.MediaSimilar + id;
            keySet.add(key);
        }
        return keySet;
    }

    public Map<Long, LinkedHashSet<Long>> getSimilarByVmsIds(Set<Long> idSet) {
        long beginTime = System.currentTimeMillis();
        Set<String> keySet = getKeySet(idSet);
        Map<String, List<Long>> detailMap = redisCache.mGet(keySet);
        Map<Long, LinkedHashSet<Long>> resultMap = new HashMap<>();
        for (Map.Entry<String, List<Long>> e : detailMap.entrySet()) {
            LinkedHashSet<Long> set = new LinkedHashSet<>(e.getValue());
            Long id = Long.parseLong(e.getKey().substring(RedisPrefix.MediaSimilar.length()));
            resultMap.put(id, set);
        }
        TimeStatisticsTools.addTime("REDIS-getSimilarByVmsIds", 1, System.currentTimeMillis() - beginTime);
        return resultMap;
    }

    public LinkedHashSet<Long> getSimilarByVmsId(Long id) {
        Map<Long, LinkedHashSet<Long>> map = getSimilarByVmsIds(SetTool.asHashSet(id));
        return map.getOrDefault(id, new LinkedHashSet<>());
    }

    public Set<Long> getNewSimilarByVmsId(Long vmsId) {
        return redisCache.get(RedisPrefix.MediaSimilarNew + vmsId);
    }
}
