package com.valor.vod.meta.cache.service.query;

import com.valor.vod.es.api.client.ESConstants;
import com.valor.vod.es.api.model.service.search.ESIdResponse;
import com.valor.vod.es.api.model.service.search.ESSearchParameter;
import com.valor.vod.es.api.model.service.search.ESTermFilterBuilder;
import com.valor.vod.es.api.model.service.search.ESTextFilterBuilder;
import com.valor.vod.meta.cache.util.EsCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Set;

@Service
public class QueryMediaTextService {

    @Autowired
    EsCache esCache;

    public ESIdResponse searchText(String text, Set<Long> userCids, int pageStart, int pageSize) {
        ESSearchParameter parameter = ESSearchParameter.builder().index(ESConstants.INDEX_MEDIA_TEXTINDEX).type(ESConstants.INDEX_MEDIA_TEXTINDEX).size(10000);
        parameter.add(ESTextFilterBuilder.builder("originalTitle").setValue(text));
        parameter.add(ESTermFilterBuilder.builder("clouds").setValues(userCids));
        parameter.getHighlightFileds().add("originalTitle");
        parameter.setFrom(pageStart);
        parameter.setSize(pageSize);
        parameter.setWithFilter(false);
        return esCache.searchIdResponse(parameter);
    }

}
