package com.valor.vod.meta.cache.service.query;

import com.valor.vod.es.api.model.service.media.MediaTrailer;
import com.valor.vod.meta.cache.service.common.QueryMediaService;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import common.base.tools.stat.TimeStatisticsTools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Service
public class QueryMediaTrailerService {
    @Autowired
    RedisCache redisCache;

    QueryMediaService<List<MediaTrailer>> queryMediaService;

    @PostConstruct
    public void init() {
        queryMediaService = new QueryMediaService<>(redisCache);
    }


    public Map<Long, List<MediaTrailer>> getMediaTrailerByVmsIds(Set<Long> idSet) {
        long beginTime = System.currentTimeMillis();
        Map<Long, List<MediaTrailer>> result = queryMediaService.getObjectByVmsIds(RedisPrefix.MediaTrailer, idSet);
        TimeStatisticsTools.addTime("REDIS-getMediaTrailerByVmsIds", 1, System.currentTimeMillis() - beginTime);
        return result;
    }
}
