package com.valor.vod.meta.cache.service.query;

import com.valor.vod.api.common.SetTool;
import com.valor.vod.es.api.model.service.media.MediaUserReview;
import com.valor.vod.meta.cache.service.common.QueryMediaService;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import common.base.tools.stat.TimeStatisticsTools;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Service
public class QueryMediaUserReviewService {
    @Autowired
    RedisCache redisCache;

    QueryMediaService<List<MediaUserReview>> queryMediaService;

    @PostConstruct
    public void init() {
        queryMediaService = new QueryMediaService<>(redisCache);
    }

    public Map<Long, List<MediaUserReview>> getMediaUserReviewByVmsIds(Set<Long> idSet) {
        long beginTime = System.currentTimeMillis();
        Map<Long, List<MediaUserReview>> result = queryMediaService.getObjectByVmsIds(RedisPrefix.MediaUserReview, idSet);
        TimeStatisticsTools.addTime("REDIS-getMediaUserReviewByVmsIds", 1, System.currentTimeMillis() - beginTime);
        return result;
    }

    public List<MediaUserReview> getMediaUserReviewByVmsId(Long id) {
        Map<Long, List<MediaUserReview>> map = getMediaUserReviewByVmsIds(SetTool.asHashSet(id));
        return map.getOrDefault(id, new ArrayList<>());
    }

}
