package com.valor.vod.meta.cache.service.query;

import com.valor.vod.meta.cache.util.RedisPrefix;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@SuppressWarnings("unchecked")
public class QueryYmlService {

    @Autowired
    private RedisTemplate redisTemplate;

    public int getDateVersion() {
        Object version = redisTemplate.opsForValue().get(RedisPrefix.YmlDateVersion);
        if (version != null) {
            return Integer.parseInt(version.toString());
        } else {
            return -1;
        }
    }

    public List<Long> queryFromTop(Set<String> randomSet) {
        int dateInt = getDateVersion();
        List<Integer> videos = (List<Integer>) redisTemplate.opsForHash()
                .multiGet(RedisPrefix.YmlTopContent + dateInt, randomSet);
        return videos.stream().filter(Objects::nonNull).map(Integer::longValue).collect(Collectors.toList());
    }
}
