package com.valor.vod.meta.cache.service.sync;

import com.valor.vod.api.model.constant.EArtworkType;
import com.valor.vod.common.tools.type.CollectionUtils;
import com.valor.vod.es.api.model.service.media.MediaDetail;
import com.valor.vod.es.api.model.service.media.MediaImage;
import com.valor.vod.es.api.model.service.media.MediaRelease;
import com.valor.vod.meta.cache.model.MediaPosterResp;
import com.valor.vod.meta.cache.service.common.SyncMediaService;
import com.valor.vod.meta.cache.util.RedisPrefix;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 *
 * @author Damon.Gao
 * @date 2022/7/6 15:54
 */
@Service
public class SyncOtherService {

    @Autowired
    private SyncMediaService syncMediaService;

    public List<MediaPosterResp> getMasterPoster(Long vmsId) {
        List<MediaImage> artworks = syncMediaService.getObject(RedisPrefix.MediaImage, vmsId);
        if (CollectionUtils.isNullOrEmpty(artworks)) {
            return new ArrayList<>();
        }
        List<MediaPosterResp> result = artworks.stream().filter(artwork -> artwork.getMaster() == 1 && Objects.equals(artwork.getArtworkType(), EArtworkType.POSTER.name()))
            .map(artwork -> {
                MediaPosterResp resp = new MediaPosterResp();
                resp.setLanguage(artwork.getLanguage());
                resp.setUrl(artwork.getUrl());
                return resp;
            }).collect(Collectors.toList());
        return result;
    }

    public List<MediaRelease> getMediaRelease(Long vmsId) {
        MediaDetail mediaDetail = syncMediaService.getObject(RedisPrefix.MediaDetail, vmsId);
        if (mediaDetail == null) {
            return new ArrayList<>();
        }
        return mediaDetail.getRelease();
    }
}
