package com.valor.vod.meta.cache.service.sync;

import com.valor.vod.meta.cache.model.config.SubtitleConfig;
import com.valor.vod.meta.cache.util.RedisCache;
import com.valor.vod.meta.cache.util.RedisPrefix;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class SyncSubtitleConfigService {

    @Autowired
    private RedisCache redisCache;

    public void setObjects(Map<String, List<SubtitleConfig>> data) {
        Map<String, List<SubtitleConfig>> pMap = new HashMap<>();
        for (Map.Entry<String, List<SubtitleConfig>> e : data.entrySet()) {
            String key = getKey(e.getKey());
            pMap.put(key, e.getValue());
        }
        redisCache.pipSetEx(pMap, 0);
    }

    private String getKey(String key) {
        return RedisPrefix.SubtitleConfig + key;
    }
}
