/*
 * Decompiled with CFR 0.152.
 */
package com.valor.vod.meta.cache.converter;

import com.valor.vod.meta.cache.model.playlist.Playlist;
import com.valor.vod.meta.cache.model.playlist.PlaylistI18n;
import com.valor.vod.meta.cache.model.playlist.PlaylistNode;
import com.valor.vod.meta.cache.model.playlist.PlaylistTag;
import com.valor.vod.meta.cache.model.playlist.Product;
import com.valor.vod.meta.model.database.constants.playlist.EPlaylistNodeStatus;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistDDO;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistI18nDDO;
import com.valor.vod.meta.model.database.ddo.playlist.PlaylistNodeDDO;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.mapstruct.Mapper;
import org.mapstruct.Named;
import org.mapstruct.factory.Mappers;

@Mapper(uses={PlaylistFactory.class, InnerWorker.class})
public interface PlaylistConvert {
    public static final PlaylistConvert INSTANCE = (PlaylistConvert)Mappers.getMapper(PlaylistConvert.class);

    public Playlist convert(PlaylistDDO var1, List<PlaylistI18nDDO> var2);

    public PlaylistI18n convert(PlaylistI18nDDO var1);

    public PlaylistNode convert(PlaylistNodeDDO var1);

    default public PlaylistNode convertIf(PlaylistNodeDDO ddo) {
        if (EPlaylistNodeStatus.DISABLE == ddo.getStatus()) {
            return null;
        }
        return this.convert(ddo);
    }

    default public List<PlaylistNode> convertIf(List<PlaylistNodeDDO> ddos) {
        return ddos.stream().map(this::convertIf).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static class InnerWorker {
        @Named(value="localDateTimeToMillis")
        public Long localDateTimeToMillis(LocalDateTime time) {
            if (time == null) {
                return null;
            }
            return time.atZone(ZoneId.of("UTC")).toInstant().toEpochMilli();
        }
    }

    public static class PlaylistFactory {
        public Playlist createPlaylist() {
            return Playlist.create();
        }

        public PlaylistI18n createPlaylistI18n() {
            return PlaylistI18n.create();
        }

        public PlaylistTag createPlaylistTag() {
            return PlaylistTag.create();
        }

        public PlaylistNode createPlaylistNode() {
            return PlaylistNode.create();
        }

        public Product createProduct() {
            return Product.create();
        }
    }
}

